/*
 * Decompiled with CFR 0.152.
 */
package fr.histoiremondiale.histoire.igraphique.donnees;

import fr.histoiremondiale.histoire.donnees.Civilisation;
import fr.histoiremondiale.histoire.igraphique.donnees.comparateurs.ComparateurParagraphesParDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class InfosParagrapheNavig
implements Comparable<Object> {
    private Integer id;
    private Civilisation civilisation;
    private int anneeDeb;
    private int anneeFin;
    private String titre;
    private List<InfosParagrapheNavig> precedents;
    private List<InfosParagrapheNavig> suivants;
    private String codeHtml;
    private String codeHtmlSimple;

    public InfosParagrapheNavig(Integer n, Civilisation civilisation, int n2, int n3, String string) {
        this.id = n;
        this.civilisation = civilisation;
        this.anneeDeb = n2;
        this.anneeFin = n3;
        this.titre = string;
        this.precedents = new ArrayList<InfosParagrapheNavig>();
        this.suivants = new ArrayList<InfosParagrapheNavig>();
    }

    @Override
    public int compareTo(Object object) {
        if (this == object) {
            return 0;
        }
        if (object == null) {
            return 1;
        }
        if (!(object instanceof InfosParagrapheNavig)) {
            throw new IllegalArgumentException("Type de param\u00e8tre invalide : " + object);
        }
        InfosParagrapheNavig infosParagrapheNavig = (InfosParagrapheNavig)object;
        if (this.anneeDeb == infosParagrapheNavig.anneeDeb) {
            return this.id - infosParagrapheNavig.id;
        }
        return this.anneeDeb - infosParagrapheNavig.anneeDeb;
    }

    public boolean anneeEstDansPeriodeCouverte(int n) {
        return this.anneeDeb <= n && n < this.anneeFin;
    }

    public int ajusterAnneeDansParagraphe(int n) {
        if (this.anneeEstDansPeriodeCouverte(n)) {
            return n;
        }
        if (n >= this.anneeFin) {
            return this.anneeFin - 1;
        }
        return this.anneeDeb;
    }

    public void modifCodeHtml(String string) {
        this.codeHtml = string;
    }

    public void modifCodeHtmlSimple(String string) {
        this.codeHtmlSimple = string;
    }

    public String ancre() {
        return (this.civilisation != null ? this.civilisation.nom() : "") + "&" + this.anneeDeb;
    }

    public List<InfosParagrapheNavig> precedentsTries() {
        ArrayList<InfosParagrapheNavig> arrayList = new ArrayList<InfosParagrapheNavig>(this.precedents);
        Collections.sort(arrayList, new ComparateurParagraphesParDate());
        return arrayList;
    }

    public List<InfosParagrapheNavig> suivantsTries() {
        ArrayList<InfosParagrapheNavig> arrayList = new ArrayList<InfosParagrapheNavig>(this.suivants);
        Collections.sort(arrayList, new ComparateurParagraphesParDate());
        return arrayList;
    }

    public Integer id() {
        return this.id;
    }

    public Civilisation civilisation() {
        return this.civilisation;
    }

    public int anneeDeb() {
        return this.anneeDeb;
    }

    public int anneeFin() {
        return this.anneeFin;
    }

    public String titre() {
        return this.titre;
    }

    public List<InfosParagrapheNavig> precedents() {
        return this.precedents;
    }

    public List<InfosParagrapheNavig> suivants() {
        return this.suivants;
    }

    public String codeHtml() {
        return this.codeHtml;
    }

    public String codeHtmlSimple() {
        return this.codeHtmlSimple;
    }

    public String afficheTitre() {
        return this.civilisation.nom() + "(" + this.anneeDeb + " \u00e0 " + this.anneeFin + ") : " + this.titre;
    }
}

