/*
 * Decompiled with CFR 0.152.
 */
package memory.chants;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import javax.swing.SwingWorker;
import memory.chants.Fenetre;
import memory.chants.GestionDonnees;
import memory.chants.JLecteurMP3;
import memory.chants.Oiseau;
import memory.lecteur.LecteurEvent;
import memory.lecteur.LecteurException;
import memory.lecteur.LecteurListener;
import memory.lecteur.LecteurMP3;
import memory.outils.BordureDouble;
import memory.outils.ModifiedFlowLayout;

public class JDialogGalerie
extends JDialog
implements LecteurListener {
    private static final long serialVersionUID = -2666219204215235505L;
    private JPanel galerie;
    private GestionDonnees gd;
    private LecteurMP3 lecteur = new LecteurMP3();

    public JDialogGalerie(Fenetre fenetre, GestionDonnees gd2) {
        super(fenetre, gd2.getTxt("titreGalerie", 0), true);
        this.getLecteur().addLecteurListener(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JDialogGalerie.this.getLecteur().stop();
                JDialogGalerie.this.dispose();
            }
        });
        this.setGd(gd2);
        Toolkit kit = Toolkit.getDefaultToolkit();
        Insets insets = kit.getScreenInsets(this.getGraphicsConfiguration());
        Dimension screen = kit.getScreenSize();
        int w = (int)(screen.getWidth() - (double)insets.left - (double)insets.right) - 20;
        int h = (int)(screen.getHeight() - (double)insets.top - (double)insets.bottom) - 20;
        int x = insets.left;
        int y = insets.top;
        Dimension dimension = new Dimension(w, h);
        this.setSize(dimension);
        this.setLocation(x, y);
        this.setGalerie(new JPanel(new ModifiedFlowLayout()));
        this.getContentPane().add(new JScrollPane(this.getGalerie(), 20, 30));
        this.creerGalerie();
        this.setVisible(true);
    }

    private void creerGalerie() {
        SwingWorker<Void, Oiseau> sw = new SwingWorker<Void, Oiseau>(){

            @Override
            protected Void doInBackground() throws Exception {
                int i = 0;
                while (i < JDialogGalerie.this.getGd().getNbDonnees()) {
                    this.publish(JDialogGalerie.this.gd.getOiseau(i));
                    ++i;
                }
                return null;
            }

            @Override
            public void process(List<Oiseau> oiseaux) {
                for (final Oiseau oiseau : oiseaux) {
                    JLabel lblImage = new JLabel(oiseau.getImage());
                    BordureDouble bordure = new BordureDouble(oiseau.getNom(), oiseau.getNomLatin());
                    final JPanel panImage = new JPanel(){
                        private static final long serialVersionUID = 2992074966342543802L;

                        @Override
                        public JToolTip createToolTip() {
                            JToolTip tip = super.createToolTip();
                            tip.setBackground(JLecteurMP3.COULEUR_INFO_BULLE);
                            tip.setForeground(Color.DARK_GRAY);
                            tip.setPreferredSize(new Dimension(500, 300));
                            return tip;
                        }

                        @Override
                        public Point getToolTipLocation(MouseEvent e) {
                            return new Point(this.getWidth(), this.getHeight());
                        }
                    };
                    panImage.setToolTipText("<html>" + JDialogGalerie.this.gd.getInfo(oiseau.getNomLatin()) + "</html>");
                    panImage.setBorder(bordure);
                    panImage.add(lblImage);
                    panImage.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            try {
                                JDialogGalerie.this.getLecteur().stop();
                                JDialogGalerie.this.getLecteur().open(new File(oiseau.getChant()));
                                JDialogGalerie.this.getLecteur().play();
                                Component[] componentArray = JDialogGalerie.this.getGalerie().getComponents();
                                int n = componentArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Component p = componentArray[n2];
                                    if (p.getBackground() == Color.RED) {
                                        p.setBackground(Color.LIGHT_GRAY);
                                    }
                                    ++n2;
                                }
                                panImage.setBackground(Color.RED);
                            }
                            catch (LecteurException e1) {
                                e1.printStackTrace();
                            }
                        }
                    });
                    JDialogGalerie.this.getGalerie().add(panImage);
                    panImage.validate();
                    JDialogGalerie.this.getGalerie().revalidate();
                    int x = 0;
                    int y = JDialogGalerie.this.getGalerie().getHeight() - 300;
                    int w = JDialogGalerie.this.getGalerie().getWidth();
                    int h = 300;
                    Rectangle r = new Rectangle(x, y, w, h);
                    JDialogGalerie.this.getGalerie().scrollRectToVisible(r);
                }
            }
        };
        sw.execute();
    }

    @Override
    public void opened(Long duree) {
    }

    @Override
    public void progress(Long microseconds) {
    }

    @Override
    public void stateUpdated(LecteurEvent event) {
        if (event.getCode() == 8) {
            try {
                this.getLecteur().play();
            }
            catch (LecteurException e) {
                e.printStackTrace();
            }
        } else if (event.getCode() == 3) {
            Component[] componentArray = this.getGalerie().getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component p = componentArray[n2];
                if (p.getBackground() == Color.RED) {
                    p.setBackground(Color.LIGHT_GRAY);
                }
                ++n2;
            }
        }
    }

    public void setGd(GestionDonnees gd) {
        this.gd = gd;
    }

    public GestionDonnees getGd() {
        return this.gd;
    }

    public void setLecteur(LecteurMP3 lecteur) {
        this.lecteur = lecteur;
    }

    public LecteurMP3 getLecteur() {
        return this.lecteur;
    }

    public void setGalerie(JPanel galerie) {
        this.galerie = galerie;
    }

    public JPanel getGalerie() {
        return this.galerie;
    }
}

