/*
 * Decompiled with CFR 0.152.
 */
package memory.chants;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import memory.chants.GestionDonnees;

public class Oiseau {
    private String nom;
    private String chant;
    private ImageIcon image;
    private int taille;
    private static FontMetrics fm;
    private String nomLatin;
    private String info;

    public Oiseau(String nom, String nomLatin, String fichierSon, String fichierImage, int tailleImage, String info) {
        Oiseau.initFontMetrics();
        this.chant = fichierSon;
        this.nom = nom;
        this.nomLatin = nomLatin;
        this.taille = tailleImage;
        this.setImage(fichierImage);
        this.setInfo(info);
    }

    private static void initFontMetrics() {
        if (fm == null) {
            Font policeTitre = new Font("Dialog", 1, 12);
            fm = new JLabel().getFontMetrics(policeTitre);
        }
    }

    public Oiseau(String nom, String latin, String fichierSon, String fichierImage, String info) {
        this(nom, latin, fichierSon, fichierImage, 300, info);
    }

    public void changeNom(String name) {
        this.nom = name;
    }

    private void setImage(String fichier) {
        ImageIcon image1 = new ImageIcon(fichier);
        int largeur = image1.getIconWidth();
        int hauteur = image1.getIconHeight();
        int largeurImage = this.taille;
        if (largeur > hauteur) {
            hauteur = hauteur * largeurImage / largeur;
            largeur = largeurImage;
        } else {
            largeur = largeur * largeurImage / hauteur;
            hauteur = largeurImage;
        }
        int largeurNom = fm.stringWidth(this.nom) + 20;
        int largeurNomLatin = fm.stringWidth(this.nomLatin) + 20;
        largeurNom = Math.max(largeurNom, largeurNomLatin);
        largeur = Math.max(largeurNom, largeur);
        this.image = new ImageIcon(image1.getImage().getScaledInstance(largeur, hauteur, 1));
    }

    public String getChant() {
        return this.chant;
    }

    public ImageIcon getImage() {
        return this.image;
    }

    public String getNom() {
        return this.nom;
    }

    public String getNomLatin() {
        return this.nomLatin;
    }

    public String getInfo() {
        if (this.info == null) {
            return "pas encore de description de l'oiseau";
        }
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public static void main(String[] args) {
        GestionDonnees gd = new GestionDonnees();
        final Oiseau oiseau = gd.getOiseau((int)(35.0 * Math.random()));
        final JPanel panneau = new JPanel();
        final JLabel label = new JLabel();
        panneau.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame fenetre = new JFrame("Test du composant oiseau");
                label.setIcon(oiseau.getImage());
                panneau.add(label);
                fenetre.add(panneau);
                fenetre.pack();
                fenetre.setDefaultCloseOperation(3);
                fenetre.setLocationRelativeTo(null);
                fenetre.setVisible(true);
            }
        });
    }
}

