/*
 * Decompiled with CFR 0.152.
 */
package fr.histoiremondiale.histoire;

import fr.histoiremondiale.histoire.donnees.Civilisation;
import fr.histoiremondiale.histoire.donnees.Territoire;
import fr.histoiremondiale.histoire.utiles.exttypes.Flottants;
import fr.histoiremondiale.histoire.utiles.igraphique.swing.Observable;
import fr.histoiremondiale.histoire.utiles.math.PlagesNombres;
import fr.histoiremondiale.histoire.utiles.math.PointSphere;

public class EtatAppli
extends Observable {
    public static final int[] VALS_PAS_ANNEES = new int[]{1, 5, 10, 25, 50, 100, 200, 500};
    public static final int[] VALS_PAS_ESPACE = new int[]{1, 2, 5, 10, 15, 20};
    public static final double MINI_LOUPE = 1.0;
    public static final double MAXI_LOUPE = 25.0;
    public static final double INCR_LOUPE = 1.3;
    public static final int PRECISION_ESPACE = 2;
    private PointSphere ptCentralCarte;
    private int annee;
    private double loupe;
    private Civilisation civilisationSelectionnee;
    private boolean suiviCivilisationSelectionnee;
    private boolean fleuvesAffiches;
    private boolean infobullesCarte;
    private boolean meridiensParallelesAffiches;
    private boolean symboleAttenteTracer;
    private boolean texteSurvolFondClair;
    private double posSeparateurCarteNavig;
    private int iDeplAnnees;
    private int iDeplEspace;
    private boolean simpleClicFermerParagraphes;
    private boolean moletteGlisseDeUn;
    private boolean affParagraphesHtmlGeneres;
    private Territoire territoireSurvole;
    private String chemRepSauvCartes;
    private String chemRepSauvParagraphes;
    private String chemRepVueParagraphes;

    public PointSphere ptCentralCarte() {
        return this.ptCentralCarte;
    }

    public double longitude() {
        return this.ptCentralCarte.longitude();
    }

    public double latitude() {
        return this.ptCentralCarte.latitude();
    }

    public double loupe() {
        return this.loupe;
    }

    public int annee() {
        return this.annee;
    }

    public synchronized Civilisation civilisationSuivie() {
        return this.suiviCivilisationSelectionnee ? this.civilisationSelectionnee : null;
    }

    public synchronized String nomCivilisationSelectionnee() {
        return this.civilisationSelectionnee == null ? null : this.civilisationSelectionnee.nom();
    }

    public synchronized boolean suiviCivilisationSelectionnee() {
        return this.suiviCivilisationSelectionnee;
    }

    public synchronized Civilisation civilisationSelectionnee() {
        return this.civilisationSelectionnee;
    }

    public synchronized boolean fleuvesAffiches() {
        return this.fleuvesAffiches;
    }

    public synchronized boolean infobullesCarte() {
        return this.infobullesCarte;
    }

    public synchronized boolean meridiensParallelesAffiches() {
        return this.meridiensParallelesAffiches;
    }

    public synchronized boolean symboleAttenteTracer() {
        return this.symboleAttenteTracer;
    }

    public synchronized boolean texteSurvolFondClair() {
        return this.texteSurvolFondClair;
    }

    public synchronized double posSeparateurCarteNavig() {
        return this.posSeparateurCarteNavig;
    }

    public synchronized int iDeplAnnees() {
        return this.iDeplAnnees;
    }

    public synchronized int deplAnnees() {
        return VALS_PAS_ANNEES[this.iDeplAnnees];
    }

    public synchronized int iDeplEspace() {
        return this.iDeplEspace;
    }

    public synchronized int deplEspace() {
        return VALS_PAS_ESPACE[this.iDeplEspace];
    }

    public synchronized boolean simpleClicFermerParagraphes() {
        return this.simpleClicFermerParagraphes;
    }

    public synchronized boolean moletteGlisseDeUn() {
        return this.moletteGlisseDeUn;
    }

    public synchronized boolean affParagraphesHtmlGeneres() {
        return this.affParagraphesHtmlGeneres;
    }

    public Territoire territoireSurvole() {
        return this.territoireSurvole;
    }

    public String chemRepSauvCartes() {
        return this.chemRepSauvCartes;
    }

    public String chemRepSauvParagraphes() {
        return this.chemRepSauvParagraphes;
    }

    public String chemRepVueParagraphes() {
        return this.chemRepVueParagraphes;
    }

    public void modifLongitude(double d) {
        this.modifCoordonneesEspaceTemps(d, null, null);
    }

    public void modifLatitude(double d) {
        this.modifCoordonneesEspaceTemps(null, d, null);
    }

    public void modifPtCentralCarte(PointSphere pointSphere) {
        if (pointSphere != null) {
            this.modifCoordonneesEspaceTemps(pointSphere.longitude(), pointSphere.latitude(), null);
        }
    }

    public void augmenterLoupe() {
        this.modifLoupe(this.loupe() * 1.3);
    }

    public void diminuerLoupe() {
        this.modifLoupe(this.loupe() / 1.3);
    }

    public void modifRelativeLoupe(double d) {
        this.modifLoupe(this.loupe() * Math.pow(1.3, d));
    }

    public void modifLoupe(double d) {
        double d2 = d;
        if (d2 > 25.0) {
            d2 = 25.0;
        }
        if (d2 < 1.0) {
            d2 = 1.0;
        }
        if (this.loupe != d2) {
            this.loupe = d2;
            this.avertirObservateurs("loupe");
        }
    }

    public void modifAnnee(int n) {
        this.modifCoordonneesEspaceTemps(null, null, n);
    }

    public void decrementerAnnee() {
        this.modifAnnee(this.annee - VALS_PAS_ANNEES[this.iDeplAnnees]);
    }

    public void incrementerAnnee() {
        this.modifAnnee(this.annee + VALS_PAS_ANNEES[this.iDeplAnnees]);
    }

    public void modifCoordonneesEspaceTemps(PointSphere pointSphere, Integer n, boolean bl) {
        Double d = pointSphere == null ? null : Double.valueOf(pointSphere.longitude());
        Double d2 = pointSphere == null ? null : Double.valueOf(pointSphere.latitude());
        this.modifCoordonneesEspaceTemps(d, d2, n, bl);
    }

    public void modifCoordonneesEspaceTemps(Double d, Double d2, Integer n) {
        this.modifCoordonneesEspaceTemps(d, d2, n, true);
    }

    public void modifCoordonneesEspaceTemps(Double d, Double d2, Integer n, Boolean bl) {
        int n2;
        boolean bl2 = false;
        boolean bl3 = false;
        double d3 = this.ptCentralCarte == null ? 0.0 : this.ptCentralCarte.longitude();
        double d4 = this.ptCentralCarte == null ? 0.0 : this.ptCentralCarte.latitude();
        int n3 = this.annee;
        double d5 = Flottants.arrondir(d == null ? d3 : PlagesNombres.dansPlageCyclique(d, -179.0, 180.0), 2);
        double d6 = Flottants.arrondir(d2 == null ? d4 : PlagesNombres.dansPlage(d2, -90.0, 90.0), 2);
        int n4 = n2 = n == null ? n3 : PlagesNombres.dansPlage(n, -3100, 2000);
        if (n2 == 0) {
            int n5 = n2 = bl != false ? 1 : -1;
        }
        if (this.ptCentralCarte == null || d != null && d != d3 || d6 != d4) {
            this.ptCentralCarte = new PointSphere(d5, d6);
            bl2 = true;
        }
        if (n2 != n3) {
            this.annee = n2;
            bl3 = true;
        }
        if (bl2) {
            this.avertirObservateurs("ptCentralCarte");
            this.avertirObservateurs("longitude");
            this.avertirObservateurs("latitude");
        }
        if (bl3) {
            this.avertirObservateurs("annee");
        }
    }

    public synchronized void modifCivilisationSelectionnee(Civilisation civilisation) {
        if (this.civilisationSelectionnee != civilisation) {
            this.civilisationSelectionnee = civilisation;
            this.avertirObservateurs("civilisationSelectionnee");
        }
    }

    public synchronized void modifSuiviCivilisationSelectionnee(boolean bl) {
        if (bl != this.suiviCivilisationSelectionnee) {
            this.suiviCivilisationSelectionnee = bl;
            this.avertirObservateurs("suiviCivilisationSelectionnee");
        }
    }

    public synchronized void inverserSuiviCivilisationSelectionnee() {
        this.modifSuiviCivilisationSelectionnee(!this.suiviCivilisationSelectionnee());
    }

    public synchronized void inverserFleuvesAffiches() {
        this.modifFleuvesAffiches(!this.fleuvesAffiches());
    }

    public synchronized void modifFleuvesAffiches(boolean bl) {
        if (this.fleuvesAffiches != bl) {
            this.fleuvesAffiches = bl;
            this.avertirObservateurs("fleuvesAffiches");
        }
    }

    public synchronized void inverserInfobullesCarte() {
        this.modifInfobullesCarte(!this.infobullesCarte());
    }

    public synchronized void modifInfobullesCarte(boolean bl) {
        if (this.infobullesCarte != bl) {
            this.infobullesCarte = bl;
            this.avertirObservateurs("infobullesCarte");
        }
    }

    public synchronized void inverserMeridiensParallelesAffiches() {
        this.modifMeridiensParallelesAffiches(!this.meridiensParallelesAffiches());
    }

    public synchronized void modifMeridiensParallelesAffiches(boolean bl) {
        if (this.meridiensParallelesAffiches != bl) {
            this.meridiensParallelesAffiches = bl;
            this.avertirObservateurs("MeridiensParallelesAffiches");
        }
    }

    public synchronized void inverserSymboleAttenteTracer() {
        this.modifSymboleAttenteTracer(!this.symboleAttenteTracer());
    }

    public synchronized void modifSymboleAttenteTracer(boolean bl) {
        if (this.symboleAttenteTracer != bl) {
            this.symboleAttenteTracer = bl;
            this.avertirObservateurs("symboleAttenteTracer");
        }
    }

    public synchronized void inverserTexteSurvolFondClair() {
        this.modifTexteSurvolFondClair(!this.texteSurvolFondClair());
    }

    public synchronized void modifTexteSurvolFondClair(boolean bl) {
        if (this.texteSurvolFondClair != bl) {
            this.texteSurvolFondClair = bl;
            this.avertirObservateurs("texteSurvolFondClair");
        }
    }

    public synchronized void modifPosSeparateurCarteNavig(double d) {
        if (this.posSeparateurCarteNavig != d) {
            this.posSeparateurCarteNavig = d;
            this.avertirObservateurs("posSeparateurCarteNavig");
        }
    }

    public void modifIDeplAnnees(int n) {
        int n2 = n;
        n2 = Math.min(n2, VALS_PAS_ANNEES.length - 1);
        if (this.iDeplAnnees != (n2 = Math.max(n2, 0))) {
            this.iDeplAnnees = n2;
            this.avertirObservateurs("iDeplAnnees");
            this.avertirObservateurs("deplAnnees");
        }
    }

    public void modifDeplAnnees(int n) {
        int n2 = -1;
        for (int i = 0; i < VALS_PAS_ANNEES.length; ++i) {
            if (VALS_PAS_ANNEES[i] < n) continue;
            n2 = i;
            break;
        }
        if (n2 == -1) {
            n2 = VALS_PAS_ANNEES.length - 1;
        }
        this.modifIDeplAnnees(n2);
    }

    public void modifIDeplEspace(int n) {
        int n2 = n;
        n2 = Math.min(n2, VALS_PAS_ESPACE.length - 1);
        if (this.iDeplEspace != (n2 = Math.max(n2, 0))) {
            this.iDeplEspace = n2;
            this.avertirObservateurs("iDeplEspace");
            this.avertirObservateurs("deplEspace");
        }
    }

    public void modifDeplEspace(int n) {
        int n2 = -1;
        for (int i = 0; i < VALS_PAS_ESPACE.length; ++i) {
            if (VALS_PAS_ESPACE[i] < n) continue;
            n2 = i;
            break;
        }
        if (n2 == -1) {
            n2 = VALS_PAS_ESPACE.length - 1;
        }
        this.modifIDeplEspace(n2);
    }

    public synchronized void inverserSimpleClicFermerParagraphes() {
        this.modifSimpleClicFermerParagraphes(!this.simpleClicFermerParagraphes());
    }

    public synchronized void modifSimpleClicFermerParagraphes(boolean bl) {
        if (this.simpleClicFermerParagraphes != bl) {
            this.simpleClicFermerParagraphes = bl;
            this.avertirObservateurs("simpleClicFermerParagraphes");
        }
    }

    public synchronized void inverserMoletteGlisseDeUn() {
        this.modifMoletteGlisseDeUn(!this.moletteGlisseDeUn());
    }

    public synchronized void modifMoletteGlisseDeUn(boolean bl) {
        if (this.moletteGlisseDeUn != bl) {
            this.moletteGlisseDeUn = bl;
            this.avertirObservateurs("moletteGlisseDeUn");
        }
    }

    public synchronized void inverserAffParagraphesHtmlGeneres() {
        this.modifAffParagraphesHtmlGeneres(!this.affParagraphesHtmlGeneres());
    }

    public synchronized void modifAffParagraphesHtmlGeneres(boolean bl) {
        if (this.affParagraphesHtmlGeneres != bl) {
            this.affParagraphesHtmlGeneres = bl;
            this.avertirObservateurs("affParagraphesHtmlGeneres");
        }
    }

    public void modifTerritoireSurvole(Territoire territoire) {
        if (this.territoireSurvole != territoire) {
            this.territoireSurvole = territoire;
            this.avertirObservateurs("territoireSurvole");
        }
    }

    public void modifTailleZoneCarte() {
        this.avertirObservateurs("taillePourCarte");
    }

    public void modifChemRepSauvCartes(String string) {
        this.chemRepSauvCartes = string;
    }

    public void modifChemRepSauvParagraphes(String string) {
        this.chemRepSauvParagraphes = string;
    }

    public void modifChemRepVueParagraphes(String string) {
        this.chemRepVueParagraphes = string;
    }
}

