/*
 * Decompiled with CFR 0.152.
 */
package fr.histoiremondiale.histoire.donnees;

import fr.histoiremondiale.histoire.donnees.Civilisation;
import fr.histoiremondiale.histoire.donnees.Pourtour;
import fr.histoiremondiale.histoire.donnees.TexteTerritoire;
import fr.histoiremondiale.histoire.utiles.math.PointSphere;
import java.awt.Color;
import java.util.Set;

public class Territoire {
    private int id;
    private int rang;
    private String nom;
    private Set<TexteTerritoire> textes;
    private Civilisation civilisation;
    private Pourtour pourtour;
    private Color coulInterieur;
    private Color coulFrontieres;
    private int styleHachures;
    private int styleFrontieres;
    private int dateDebut;
    private int dateFin;
    private double valLoupeLimiteAff;

    public Territoire(int n, int n2, String string, Set<TexteTerritoire> set, Civilisation civilisation, Color color, Color color2, int n3, int n4, int n5, int n6, double d, Pourtour pourtour) {
        this.id = n;
        this.rang = n2;
        this.nom = string;
        this.textes = set;
        this.civilisation = civilisation;
        this.coulInterieur = color;
        this.coulFrontieres = color2;
        this.styleHachures = n3;
        this.styleFrontieres = n4;
        this.dateDebut = n5;
        this.dateFin = n6;
        this.valLoupeLimiteAff = d;
        this.pourtour = pourtour;
    }

    public Territoire(int n) {
        this.id = n;
    }

    public TexteTerritoire texteEn(int n) {
        for (TexteTerritoire texteTerritoire : this.textes) {
            if (!texteTerritoire.afficheEn(n)) continue;
            return texteTerritoire;
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        return this.id == ((Territoire)object).id;
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return "" + this.id + " : " + this.nom + " : " + this.dateDebut + " -> " + this.dateFin;
    }

    public String enChaine() {
        return "" + this.id + " : " + this.nomNormalise() + " : " + this.dateDebut + " -> " + this.dateFin;
    }

    public int id() {
        return this.id;
    }

    public int rang() {
        return this.rang;
    }

    public String nom() {
        return this.nom;
    }

    public String nomNormalise() {
        return this.nom.replace('$', ' ');
    }

    public Set<TexteTerritoire> textes() {
        return this.textes;
    }

    public Pourtour pourtour() {
        return this.pourtour;
    }

    public Color coulInterieur() {
        return this.coulInterieur;
    }

    public Color coulFrontieres() {
        return this.coulFrontieres;
    }

    public int styleHachures() {
        return this.styleHachures;
    }

    public int styleFrontieres() {
        return this.styleFrontieres;
    }

    public int dateDebut() {
        return this.dateDebut;
    }

    public int dateFin() {
        return this.dateFin;
    }

    public PointSphere pointCentral() {
        return this.pourtour.centreCercleLimite();
    }

    public Civilisation civilisation() {
        return this.civilisation;
    }

    public double valLoupeLimiteAff() {
        return this.valLoupeLimiteAff;
    }
}

