/*
 * Decompiled with CFR 0.152.
 */
package fr.histoiremondiale.histoire.igraphique;

import fr.histoiremondiale.histoire.HistoireMondiale;
import fr.histoiremondiale.histoire.donnees.Territoire;
import fr.histoiremondiale.histoire.igraphique.PanCarte;
import fr.histoiremondiale.histoire.igraphique.actions.ActionsEspaceTemps;
import fr.histoiremondiale.histoire.igraphique.composants.BarreLoupe;
import fr.histoiremondiale.histoire.utiles.igraphique.swing.Fenetres;
import fr.histoiremondiale.histoire.utiles.math.CoordSphere;
import fr.histoiremondiale.histoire.utiles.math.Matrice;
import fr.histoiremondiale.histoire.utiles.math.PointPlan;
import fr.histoiremondiale.histoire.utiles.math.PointSphere;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DialLimiteVisibiliteTerritoire
extends JDialog
implements ActionListener,
WindowListener,
ChangeListener {
    private Territoire territoire;
    private BarreLoupe barre;
    private JCheckBox cc_territoireTjsVisible;
    private JPanel sud;
    private JPanel boutons;
    private JButton btnOK;
    private JButton btnAnnul;
    private double valeurInitiale;
    private double loupe;

    public DialLimiteVisibiliteTerritoire(JFrame jFrame, Territoire territoire, double d, double d2, double d3, double d4) {
        super(jFrame, territoire.nomNormalise(), true);
        this.valeurInitiale = d3;
        this.territoire = territoire;
        this.loupe = d4;
        this.sud = new JPanel();
        this.boutons = new JPanel();
        this.barre = new BarreLoupe(d, d2, d3, d4);
        this.cc_territoireTjsVisible = new JCheckBox("Toujours visible");
        this.btnOK = new JButton("OK");
        this.btnAnnul = new JButton("Annuler");
        this.boutons.add(this.btnOK);
        this.boutons.add(this.btnAnnul);
        this.sud.setLayout(new BorderLayout());
        this.sud.add((Component)this.cc_territoireTjsVisible, "North");
        this.sud.add((Component)this.boutons, "South");
        this.setLayout(new BorderLayout());
        this.add((Component)this.barre, "Center");
        this.add((Component)this.sud, "South");
        this.cc_territoireTjsVisible.setSelected(d3 == 0.0);
        this.barre.addChangeListener(this);
        this.btnOK.addActionListener(this);
        this.btnAnnul.addActionListener(this);
        this.cc_territoireTjsVisible.addActionListener(this);
        this.addWindowListener(this);
        Dimension dimension = this.getMinimumSize();
        int n = Math.max(dimension.width, this.largeur(this.getTitle()) + 80);
        n = (int)Math.max((double)n, this.cc_territoireTjsVisible.getMinimumSize().getWidth());
        n = (int)Math.max((double)n, this.btnOK.getMinimumSize().getWidth() + this.btnAnnul.getMinimumSize().getWidth() + 30.0);
        int n2 = dimension.height;
        this.setMinimumSize(new Dimension(n, n2));
        this.setPreferredSize(this.getMinimumSize());
        this.pack();
        Fenetres.ajouterEcouteurEchapPourMasquer(this);
        Fenetres.centrer(this, (Frame)jFrame);
    }

    public void positionner() {
        PointSphere pointSphere = HistoireMondiale.instance().donneesIGraphique().centreTexteTerritoire(this.territoire);
        PointSphere pointSphere2 = HistoireMondiale.instance().etat().ptCentralCarte();
        PanCarte panCarte = HistoireMondiale.instance().fenPrincipale().p_carte;
        int n = panCarte.getLocationOnScreen().y;
        int n2 = panCarte.getLocationOnScreen().x;
        int n3 = panCarte.getWidth();
        int n4 = panCarte.getHeight();
        int n5 = Math.max(n4, n3);
        Matrice matrice = CoordSphere.matChgtSphereVersPlan2(pointSphere2);
        PointPlan pointPlan = CoordSphere.projection(pointSphere, matrice, this.loupe, n5);
        int n6 = pointPlan.x() > 0.0 ? n2 : n2 + n3 - this.getWidth();
        int n7 = pointPlan.y() > 0.0 ? n + n4 - this.getHeight() : n;
        this.setLocation(n6, n7);
    }

    private int largeur(String string) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        return fontMetrics.stringWidth(string);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.btnOK) {
            double d = this.cc_territoireTjsVisible.isSelected() ? 0.0 : this.barre.getValeur();
            ActionsEspaceTemps.modifierLoupeTerritoire(this.territoire, d);
            this.dispose();
        } else if (actionEvent.getSource() == this.btnAnnul) {
            ActionsEspaceTemps.modifierLoupeTerritoire(this.territoire, this.valeurInitiale);
            this.dispose();
        } else if (actionEvent.getSource() == this.cc_territoireTjsVisible) {
            if (this.cc_territoireTjsVisible.isSelected()) {
                this.barre.setValeur(0.0);
                ActionsEspaceTemps.modifierLoupeTerritoire(this.territoire, 0.0);
            }
        } else {
            throw new IllegalStateException("Source inconnue : " + actionEvent.getSource());
        }
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        ActionsEspaceTemps.modifierLoupeTerritoire(this.territoire, this.valeurInitiale);
        this.dispose();
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.cc_territoireTjsVisible.setSelected(false);
        ActionsEspaceTemps.modifierLoupeTerritoire(this.territoire, this.barre.getValeur());
    }
}

