/*
 * Decompiled with CFR 0.152.
 */
package fr.histoiremondiale.histoire.igraphique.actions;

import fr.histoiremondiale.histoire.DonneesIGraphique;
import fr.histoiremondiale.histoire.EtatAppli;
import fr.histoiremondiale.histoire.HistoireMondiale;
import fr.histoiremondiale.histoire.donnees.Civilisation;
import fr.histoiremondiale.histoire.donnees.Territoire;
import fr.histoiremondiale.histoire.igraphique.FenPageHTML;
import fr.histoiremondiale.histoire.igraphique.FenPrincipale;
import fr.histoiremondiale.histoire.igraphique.PanCarte;
import fr.histoiremondiale.histoire.igraphique.actions.ActionsEspaceTemps;
import fr.histoiremondiale.histoire.igraphique.actions.ActionsFenetres;
import fr.histoiremondiale.histoire.igraphique.actions.ActionsNavigateur;
import fr.histoiremondiale.histoire.igraphique.composants.FiltreSelectionFichiersPNG;
import fr.histoiremondiale.histoire.igraphique.composants.FiltreSelectionRepertoire;
import fr.histoiremondiale.histoire.igraphique.donnees.InfosParagrapheNavig;
import fr.histoiremondiale.histoire.igraphique.tracercartes.DemandeTracerCarte;
import fr.histoiremondiale.histoire.igraphique.tracercartes.InfosTracerImage;
import fr.histoiremondiale.histoire.stockage.ExporteurHTML;
import fr.histoiremondiale.histoire.stockage.ExporteurPNG;
import fr.histoiremondiale.histoire.utiles.es.fichiers.Fichiers;
import fr.histoiremondiale.histoire.utiles.exceptions.Exceptions;
import fr.histoiremondiale.histoire.utiles.exttypes.Chaines;
import fr.histoiremondiale.histoire.utiles.exttypes.Flottants;
import fr.histoiremondiale.histoire.utiles.igraphique.dessin.Images;
import fr.histoiremondiale.histoire.utiles.math.CalculsPlan;
import fr.histoiremondiale.histoire.utiles.math.CoordSphere;
import fr.histoiremondiale.histoire.utiles.math.Matrice;
import fr.histoiremondiale.histoire.utiles.math.PointPlan;
import fr.histoiremondiale.histoire.utiles.math.PointSphere;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

public class ActionsCarte {
    private static Point pointDepartGlissementSouris;
    private static PointSphere pointDepartCentreTexte;
    private static Territoire territoireTexteEnDeplacement;
    private static JFileChooser selectFicSauvCarte;
    private static JFileChooser selectFicSauvCarteEtParagraphe;
    private static JFileChooser selectFicParagrapheSauvegarde;

    public static void initierDeplacementTexteTerritoireEn(int n, int n2) {
        HistoireMondiale histoireMondiale = HistoireMondiale.instance();
        Territoire territoire = ActionsCarte.texteEn(n, n2);
        if (territoire == null) {
            pointDepartGlissementSouris = null;
            pointDepartCentreTexte = null;
            territoireTexteEnDeplacement = null;
        } else {
            DonneesIGraphique donneesIGraphique = histoireMondiale.donneesIGraphique();
            pointDepartGlissementSouris = new Point(n, n2);
            pointDepartCentreTexte = donneesIGraphique.centreTexteTerritoire(territoire);
            territoireTexteEnDeplacement = territoire;
        }
    }

    public static void deplacerTexteTerritoire(int n, int n2) {
        HistoireMondiale histoireMondiale = HistoireMondiale.instance();
        DonneesIGraphique donneesIGraphique = histoireMondiale.donneesIGraphique();
        PanCarte panCarte = histoireMondiale.fenPrincipale().p_carte;
        InfosTracerImage infosTracerImage = panCarte.gestTracerCartes().infosImageActuelle();
        DemandeTracerCarte demandeTracerCarte = infosTracerImage.ancImg.demande;
        if (n >= 0 && n < panCarte.getWidth() && n2 >= 0 && n2 < panCarte.getHeight() && pointDepartGlissementSouris != null) {
            PointSphere pointSphere = demandeTracerCarte.ptCentrePlan;
            double d = demandeTracerCarte.loupe;
            int n3 = demandeTracerCarte.largeurCarte;
            int n4 = demandeTracerCarte.hauteurCarte;
            int n5 = n - (int)pointDepartGlissementSouris.getX();
            int n6 = n2 - (int)pointDepartGlissementSouris.getY();
            int n7 = Math.max(n3, n4);
            Matrice matrice = CoordSphere.matChgtSphereVersPlan2(pointSphere);
            PointPlan pointPlan = CalculsPlan.changementOrigineCentreVersCoinHautGauche(CoordSphere.projection(pointDepartCentreTexte, matrice, d, n7), n3, n4);
            PointPlan pointPlan2 = new PointPlan(pointPlan.x() + (double)n5, pointPlan.y() + (double)n6);
            PointSphere pointSphere2 = CoordSphere.InvProjection(pointPlan2, pointSphere, n3, n4, d);
            donneesIGraphique.modifCentreTexteTerritoire(territoireTexteEnDeplacement, pointSphere2);
        }
    }

    public static void centrerCarteSur(int n, int n2) {
        HistoireMondiale histoireMondiale = HistoireMondiale.instance();
        PointSphere pointSphere = histoireMondiale.etat().ptCentralCarte();
        double d = histoireMondiale.etat().loupe();
        int n3 = histoireMondiale.fenPrincipale().p_carte.getWidth();
        int n4 = histoireMondiale.fenPrincipale().p_carte.getHeight();
        PointSphere pointSphere2 = CoordSphere.InvProjection(new PointPlan(n, n2), pointSphere, n3, n4, d);
        ActionsEspaceTemps.centrerCarteSurPosition(pointSphere2);
    }

    public static void centrerCarteSiNonTexteSur(int n, int n2) {
        if (ActionsCarte.texteEn(n, n2) == null) {
            ActionsCarte.centrerCarteSur(n, n2);
        }
    }

    public static void centrerCarteSiOrigineTexteSur(int n, int n2) {
        if (pointDepartGlissementSouris != null) {
            ActionsCarte.centrerCarteSur(n, n2);
        }
    }

    public static void centrerCarteSurCivilisation(Civilisation civilisation, int n) {
        HistoireMondiale.instance().etat().modifPtCentralCarte(civilisation.ptCentral(n));
    }

    public static void affParagrapheTerritoireEn(int n, int n2) {
        HistoireMondiale histoireMondiale = HistoireMondiale.instance();
        EtatAppli etatAppli = histoireMondiale.etat();
        Territoire territoire = ActionsCarte.territoireOuTexteEn(n, n2);
        if (territoire != null) {
            Civilisation civilisation = territoire.civilisation();
            int n3 = etatAppli.annee();
            if (civilisation != null) {
                InfosParagrapheNavig infosParagrapheNavig = histoireMondiale.donneesIGraphique().paragrapheParCriteres(civilisation, n3);
                ActionsNavigateur.afficherParagraphe(infosParagrapheNavig);
                etatAppli.modifCivilisationSelectionnee(civilisation);
            }
        }
    }

    public static void affDialVisibiliteTerritoireEn(int n, int n2) {
        Territoire territoire = ActionsCarte.territoireOuTexteEn(n, n2);
        if (territoire != null) {
            ActionsFenetres.affDialVisibiliteTerritoire(territoire);
        }
    }

    public static void reinitialiserTerritoireSurvole() {
        HistoireMondiale.instance().etat().modifTerritoireSurvole(null);
    }

    public static void definirTerritoireSurvole(int n, int n2) {
        HistoireMondiale histoireMondiale = HistoireMondiale.instance();
        PanCarte panCarte = histoireMondiale.fenPrincipale().p_carte;
        InfosTracerImage infosTracerImage = panCarte.gestTracerCartes().infosImageActuelle();
        if (infosTracerImage.imageDisponible()) {
            histoireMondiale.etat().modifTerritoireSurvole(ActionsCarte.territoireEn(n, n2));
        }
    }

    public static void reinitialiserInfobullesPanneau() {
        HistoireMondiale.instance().fenPrincipale().p_carte.setToolTipText(null);
    }

    public static void ajusterInfobullesPanneau(int n, int n2) {
        HistoireMondiale histoireMondiale = HistoireMondiale.instance();
        EtatAppli etatAppli = histoireMondiale.etat();
        PanCarte panCarte = histoireMondiale.fenPrincipale().p_carte;
        InfosTracerImage infosTracerImage = panCarte.gestTracerCartes().infosImageActuelle();
        if (infosTracerImage.imageDisponible()) {
            Territoire territoire = ActionsCarte.territoireEn(n, n2);
            Territoire territoire2 = ActionsCarte.texteEn(n, n2);
            if (!etatAppli.infobullesCarte()) {
                ActionsCarte.reinitialiserInfobullesPanneau();
            } else if (territoire2 != null) {
                panCarte.setToolTipText("Clic gauche (glisser) pour d\u00e9placer le texte,\n clic droit pour afficher le Paragraphe, maj + clic droit pour r\u00e9gler le niveau de visibilit\u00e9 du texte.");
            } else if (territoire != null) {
                panCarte.setToolTipText("Clic gauche pour centrer la carte sur ce point, clic droit pour afficher le Paragraphe, maj + clic droit pour r\u00e9gler le niveau de visibilit\u00e9 du texte.");
            } else {
                panCarte.setToolTipText("Clic gauche pour centrer la carte sur ce point.");
            }
        }
    }

    public static void modifierTailleDispoPourCarte() {
        HistoireMondiale.instance().etat().modifTailleZoneCarte();
    }

    public static void sauvegarderCarte() {
        File file;
        HistoireMondiale histoireMondiale = HistoireMondiale.instance();
        EtatAppli etatAppli = histoireMondiale.etat();
        PanCarte panCarte = histoireMondiale.fenPrincipale().p_carte;
        BufferedImage bufferedImage = panCarte.imageCarteActuelle();
        if (bufferedImage == null) {
            JOptionPane.showMessageDialog(panCarte, "Pas de carte \u00e0 sauvegarder : aucune carte affich\u00e9e", "Erreur de sauvegarde de la carte", 0);
            return;
        }
        if (selectFicSauvCarte == null) {
            selectFicSauvCarte = new JFileChooser();
            selectFicSauvCarte.setFileFilter(new FiltreSelectionFichiersPNG());
            selectFicSauvCarte.setAcceptAllFileFilterUsed(false);
            selectFicSauvCarte.setDialogTitle("Choix d'un nom de fichier");
        }
        do {
            String string = etatAppli.chemRepSauvCartes() == null ? System.getProperty("user.home") : etatAppli.chemRepSauvCartes();
            String string2 = (etatAppli.civilisationSelectionnee() == null ? "histoiremondiale " : etatAppli.civilisationSelectionnee().nom() + " ") + "(" + Flottants.formater(etatAppli.ptCentralCarte().longitude()) + ";" + Flottants.formater(etatAppli.ptCentralCarte().latitude()) + ") " + Flottants.formater(etatAppli.loupe()) + "x en " + etatAppli.annee() + ".png";
            selectFicSauvCarte.setSelectedFile(new File(string + File.separator + string2));
            int n = selectFicSauvCarte.showSaveDialog(panCarte);
            if (n != 0) {
                return;
            }
            file = selectFicSauvCarte.getSelectedFile();
            if (!Fichiers.extensionEgale(file.getName(), "png")) {
                file = new File(file.getAbsolutePath() + ".png");
            }
            if (file.isDirectory()) {
                JOptionPane.showMessageDialog(panCarte, "Vous devez choisir un fichier et non un r\u00e9pertoire.", "Erreur de sauvegarde de la carte", 0);
                file = null;
                continue;
            }
            if (!file.exists() || JOptionPane.showConfirmDialog(panCarte, "Le fichier existe d\u00e9j\u00e0. Voulez-vous l'\u00e9craser ?", "Confirmation de remplacement du fichier", 2) == 0) continue;
            file = null;
        } while (file == null);
        try {
            new ExporteurPNG().exporter(Images.copie(bufferedImage, panCarte), file);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            JOptionPane.showMessageDialog(panCarte, "Erreur lors de la sauvegarde de la carte :\n" + Exceptions.extraireMessagesErreur(throwable), "Erreur de sauvegarde", 0);
        }
        etatAppli.modifChemRepSauvCartes(file.getParent());
    }

    public static void sauvegarderCarteEtParagraphe() {
        String string;
        File file;
        HistoireMondiale histoireMondiale = HistoireMondiale.instance();
        EtatAppli etatAppli = histoireMondiale.etat();
        PanCarte panCarte = histoireMondiale.fenPrincipale().p_carte;
        Civilisation civilisation = etatAppli.civilisationSelectionnee();
        int n = etatAppli.annee();
        PointSphere pointSphere = etatAppli.ptCentralCarte();
        if (civilisation == null) {
            JOptionPane.showMessageDialog(panCarte, "Aucune civilisation s\u00e9lectionn\u00e9e", "Erreur de sauvegarde de la carte", 0);
            return;
        }
        InfosParagrapheNavig infosParagrapheNavig = histoireMondiale.donneesIGraphique().paragrapheParCriteres(civilisation, n);
        BufferedImage bufferedImage = panCarte.imageCarteActuelle();
        if (bufferedImage == null) {
            JOptionPane.showMessageDialog(panCarte, "Pas de carte \u00e0 sauvegarder : aucune carte affich\u00e9e", "Erreur de sauvegarde de la carte", 0);
            return;
        }
        if (selectFicSauvCarteEtParagraphe == null) {
            selectFicSauvCarteEtParagraphe = new JFileChooser();
            selectFicSauvCarteEtParagraphe.setFileSelectionMode(1);
            selectFicSauvCarteEtParagraphe.setFileFilter(new FiltreSelectionRepertoire());
            selectFicSauvCarteEtParagraphe.setAcceptAllFileFilterUsed(false);
            selectFicSauvCarteEtParagraphe.setDialogTitle("Choix d'un r\u00e9pertoire pour g\u00e9n\u00e9rer la page");
        }
        do {
            string = etatAppli.chemRepSauvParagraphes() == null ? System.getProperty("user.home") : etatAppli.chemRepSauvParagraphes();
            selectFicSauvCarteEtParagraphe.setCurrentDirectory(new File(string + File.separator));
            int n2 = selectFicSauvCarteEtParagraphe.showSaveDialog(panCarte);
            if (n2 != 0) {
                return;
            }
            file = selectFicSauvCarteEtParagraphe.getSelectedFile();
            if (!file.exists() || file.isDirectory()) continue;
            JOptionPane.showMessageDialog(panCarte, "Ce n'est pas un r\u00e9pertoire.\nChoisissez un r\u00e9pertoire dans lequel g\u00e9n\u00e9rer les fichiers.", "Erreur de sauvegarde de la carte", 0);
            file = null;
        } while (file == null);
        string = null;
        try {
            string = new ExporteurHTML().exporter(infosParagrapheNavig, n, pointSphere, Images.copie(bufferedImage, panCarte), file);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            JOptionPane.showMessageDialog(panCarte, "Erreur lors de la sauvegarde de la carte :\n" + Exceptions.extraireMessagesErreur(throwable), "Erreur de sauvegarde", 0);
        }
        etatAppli.modifChemRepSauvParagraphes(file.getAbsolutePath());
        if (etatAppli.affParagraphesHtmlGeneres() && string != null) {
            ActionsCarte.afficherFenParagraphe(string, histoireMondiale.fenPrincipale());
        }
    }

    public static void visualiserParagraphe() {
        Object object;
        HistoireMondiale histoireMondiale = HistoireMondiale.instance();
        EtatAppli etatAppli = histoireMondiale.etat();
        PanCarte panCarte = histoireMondiale.fenPrincipale().p_carte;
        if (selectFicParagrapheSauvegarde == null) {
            selectFicParagrapheSauvegarde = new JFileChooser();
            selectFicParagrapheSauvegarde.setMultiSelectionEnabled(false);
            selectFicParagrapheSauvegarde.setFileSelectionMode(0);
            object = new FileNameExtensionFilter("Fichiers html", "html");
            selectFicParagrapheSauvegarde.addChoosableFileFilter((FileFilter)object);
        }
        object = etatAppli.chemRepVueParagraphes() != null ? etatAppli.chemRepVueParagraphes() : (etatAppli.chemRepSauvParagraphes() != null ? etatAppli.chemRepSauvParagraphes() : System.getProperty("user.home"));
        selectFicParagrapheSauvegarde.setCurrentDirectory(new File((String)object + File.separator));
        if (selectFicParagrapheSauvegarde.showOpenDialog(panCarte) == 0) {
            ActionsCarte.afficherFenParagraphe(selectFicParagrapheSauvegarde.getSelectedFile().getAbsolutePath(), histoireMondiale.fenPrincipale());
            etatAppli.modifChemRepVueParagraphes(selectFicParagrapheSauvegarde.getSelectedFile().getParent());
        }
    }

    private static void afficherFenParagraphe(String string, FenPrincipale fenPrincipale) {
        try {
            BufferedImage bufferedImage = ImageIO.read(new File(ActionsCarte.determinerChemImage(string)));
            FenPageHTML fenPageHTML = new FenPageHTML("Carte", Fichiers.urlLocaleDeNomFichier(string), ((Image)bufferedImage).getWidth(null), ((Image)bufferedImage).getHeight(null), fenPrincipale);
            fenPageHTML.setVisible(true);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            JOptionPane.showMessageDialog(null, "Erreur lors de l'affichage de la carte.", "Erreur d'affichage de la page", 0);
        }
    }

    private static String determinerChemImage(String string) {
        String string2 = "";
        try {
            string2 = Fichiers.chargerContenuTexte(new File(string));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        string2 = Chaines.entreMarqueurs(string2, "<img src=\"", "\"");
        String string3 = string2.replace("/", File.separator);
        if (string3.startsWith("..")) {
            while (string3.startsWith("..")) {
                string3 = string3.substring(3);
                int n = string.lastIndexOf(File.separator);
                string = string.substring(0, n + 1);
            }
            string3 = string + string3;
        } else if (string2.startsWith(".")) {
            int n = string.lastIndexOf(File.separator);
            string = string.substring(0, n + 1);
            string3 = string + string3.replace("." + File.separator, "");
        } else if (!string3.contains(File.separator)) {
            int n = string.lastIndexOf(File.separator);
            string = string.substring(0, n + 1);
            string3 = string + string3;
        }
        return string3;
    }

    private static Territoire texteEn(int n, int n2) {
        PanCarte panCarte = HistoireMondiale.instance().fenPrincipale().p_carte;
        InfosTracerImage infosTracerImage = panCarte.gestTracerCartes().infosImageActuelle();
        if (infosTracerImage.imageDisponible()) {
            PointPlan pointPlan = panCarte.posPanneauVersPosImgCarte(n, n2);
            return infosTracerImage.territoireTexteAuxCoordonnees(pointPlan.x(), pointPlan.y());
        }
        return null;
    }

    private static Territoire territoireEn(int n, int n2) {
        PanCarte panCarte = HistoireMondiale.instance().fenPrincipale().p_carte;
        InfosTracerImage infosTracerImage = panCarte.gestTracerCartes().infosImageActuelle();
        if (infosTracerImage.imageDisponible()) {
            PointPlan pointPlan = panCarte.posPanneauVersPosImgCarte(n, n2);
            return infosTracerImage.territoireAuxCoordonnees(pointPlan.x(), pointPlan.y());
        }
        return null;
    }

    private static Territoire territoireOuTexteEn(int n, int n2) {
        Territoire territoire = ActionsCarte.texteEn(n, n2);
        if (territoire == null) {
            territoire = ActionsCarte.territoireEn(n, n2);
        }
        return territoire;
    }
}

