/*
 * Decompiled with CFR 0.152.
 */
package fr.histoiremondiale.histoire.igraphique.actions;

import fr.histoiremondiale.histoire.EtatAppli;
import fr.histoiremondiale.histoire.HistoireMondiale;
import fr.histoiremondiale.histoire.igraphique.FenPageHTML;
import fr.histoiremondiale.histoire.igraphique.FenPrincipale;
import fr.histoiremondiale.histoire.igraphique.PanNavigateur;
import fr.histoiremondiale.histoire.igraphique.ParagrapheNavig;
import fr.histoiremondiale.histoire.igraphique.composants.DialogBiblio;
import fr.histoiremondiale.histoire.igraphique.donnees.InfosParagrapheNavig;
import fr.histoiremondiale.histoire.stockage.AccesDonneesBase;
import fr.histoiremondiale.histoire.utiles.es.fichiers.Fichiers;
import fr.histoiremondiale.histoire.utiles.exceptions.Exceptions;
import fr.histoiremondiale.histoire.utiles.math.PointSphere;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import javax.swing.JOptionPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;

public class ActionsNavigateur {
    public static void afficherParagraphe(InfosParagrapheNavig infosParagrapheNavig) {
        if (infosParagrapheNavig != null) {
            HistoireMondiale.instance().fenPrincipale().p_navigateur.afficherParagraphe(infosParagrapheNavig);
        }
    }

    public static void modifierSuiviCivilisation(boolean bl) {
        HistoireMondiale.instance().etat().modifSuiviCivilisationSelectionnee(bl);
    }

    public static void inverserSuiviCivilisationSelectionnee() {
        HistoireMondiale.instance().etat().inverserSuiviCivilisationSelectionnee();
    }

    public static void naviguer(ParagrapheNavig paragrapheNavig, Point point) {
        int n;
        HistoireMondiale histoireMondiale = HistoireMondiale.instance();
        FenPrincipale fenPrincipale = histoireMondiale.fenPrincipale();
        PanNavigateur panNavigateur = fenPrincipale.p_navigateur;
        HTMLDocument hTMLDocument = (HTMLDocument)paragrapheNavig.getDocument();
        Element element = hTMLDocument.getCharacterElement(n = paragrapheNavig.viewToModel(point));
        AttributeSet attributeSet = element.getAttributes();
        AttributeSet attributeSet2 = (AttributeSet)attributeSet.getAttribute(HTML.Tag.A);
        if (attributeSet2 != null) {
            String string = (String)attributeSet2.getAttribute(HTML.Attribute.HREF);
            if (string.startsWith("#")) {
                String string2 = string.substring("#".length());
                InfosParagrapheNavig infosParagrapheNavig = HistoireMondiale.instance().donneesIGraphique().paragrapheParAncre(string2);
                panNavigateur.afficherParagraphe(infosParagrapheNavig);
                int n2 = histoireMondiale.etat().annee();
                int n3 = infosParagrapheNavig.ajusterAnneeDansParagraphe(n2);
                if (n2 != n3) {
                    panNavigateur.desactiverReactionChangementAnnee();
                    histoireMondiale.etat().modifAnnee(n3);
                    panNavigateur.reactiverReactionChangementAnnee();
                }
            } else if (string.equals("bibliographie.html")) {
                ActionsNavigateur.afficherBibliographie(paragrapheNavig);
            } else {
                String string3 = HistoireMondiale.instance().config().chemRepPagesHtml();
                String string4 = Fichiers.urlLocaleDeNomFichier(string3 + File.separator) + "/" + string;
                try {
                    new FenPageHTML("", string4, 600, 400).setVisible(true);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    System.err.println(iOException.getMessage());
                    JOptionPane.showMessageDialog(null, "Impossible d'acc\u00e9der au fichier d\u00e9sign\u00e9 par ce lien\nFichier : " + string4 + "\nMessage d'erreur : " + Exceptions.extraireMessagesErreur(iOException), "Erreur de suivi du lien", 0);
                }
            }
        }
    }

    private static void afficherBibliographie(ParagrapheNavig paragrapheNavig) {
        InfosParagrapheNavig infosParagrapheNavig = paragrapheNavig.paragraphe();
        int n = infosParagrapheNavig.id();
        try {
            String string = AccesDonneesBase.obtenirBiblio(n);
            if (string != null) {
                DialogBiblio dialogBiblio = new DialogBiblio(string, HistoireMondiale.instance().fenPrincipale());
                dialogBiblio.setVisible(true);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public static void affVueCorrespondante(InfosParagrapheNavig infosParagrapheNavig) {
        HistoireMondiale histoireMondiale = HistoireMondiale.instance();
        EtatAppli etatAppli = histoireMondiale.etat();
        FenPrincipale fenPrincipale = histoireMondiale.fenPrincipale();
        PanNavigateur panNavigateur = fenPrincipale.p_navigateur;
        if (infosParagrapheNavig.civilisation() != null) {
            PointSphere pointSphere = infosParagrapheNavig.civilisation().ptCentral(etatAppli.annee());
            int n = infosParagrapheNavig.ajusterAnneeDansParagraphe(etatAppli.annee());
            etatAppli.modifCoordonneesEspaceTemps(pointSphere, n, true);
            panNavigateur.afficherParagraphe(infosParagrapheNavig);
            etatAppli.modifCivilisationSelectionnee(infosParagrapheNavig.civilisation());
        }
    }
}

