/*
 * Decompiled with CFR 0.152.
 */
package fr.histoiremondiale.histoire.igraphique.evenements;

import fr.histoiremondiale.histoire.igraphique.DialAnnee;
import fr.histoiremondiale.histoire.igraphique.DialCentre;
import fr.histoiremondiale.histoire.igraphique.DialLoupe;
import fr.histoiremondiale.histoire.igraphique.FenPrincipale;
import fr.histoiremondiale.histoire.igraphique.PanCarte;
import fr.histoiremondiale.histoire.igraphique.PanNavigateur;
import fr.histoiremondiale.histoire.igraphique.ParagrapheNavig;
import fr.histoiremondiale.histoire.igraphique.actions.ActionsCarte;
import fr.histoiremondiale.histoire.igraphique.actions.ActionsEspaceTemps;
import fr.histoiremondiale.histoire.igraphique.actions.ActionsFenetres;
import fr.histoiremondiale.histoire.igraphique.actions.ActionsGeneralesAppli;
import fr.histoiremondiale.histoire.igraphique.actions.ActionsNavigateur;
import fr.histoiremondiale.histoire.igraphique.actions.ActionsOptionsGraphiques;
import fr.histoiremondiale.histoire.igraphique.composants.ConteneurValeur;
import fr.histoiremondiale.histoire.igraphique.composants.GlissiereDates;
import fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.Evenement;
import fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.GestEvenementsGenerique;
import fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.ecouteurs.EcouteurClicDroit;
import fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.ecouteurs.EcouteurClicGauche;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.EventObject;
import javax.swing.JScrollBar;

public class GestEvenementsHistoireMondiale
extends GestEvenementsGenerique {
    private FenPrincipale fenPrincipale;
    private DialLoupe dialLoupe;
    private DialAnnee dialAnnee;
    private DialCentre dialCentre;

    public void declarerCapturesEvenementsFenPrincipale(FenPrincipale fenPrincipale) {
        this.fenPrincipale = fenPrincipale;
        this.pressionGauche(fenPrincipale.bt_loupe);
        this.pressionDroit(fenPrincipale.bt_loupe);
        this.moletteSouris(fenPrincipale.p_carte);
        this.clicGauche(fenPrincipale.txt_loupe);
        this.clicGauche(fenPrincipale.txt_annee);
        this.clicGauche(fenPrincipale.txt_pointCentral);
        this.clicGaucheEltsMenu(fenPrincipale.menu_fichier);
        this.raccourciClavierEltMenu(fenPrincipale.eltmenu_ficReinitValeurs, "control I");
        this.raccourciClavierEltMenu(fenPrincipale.eltmenu_ficExporterCarte, "F2");
        this.raccourciClavierEltMenu(fenPrincipale.eltmenu_ficExporterCarteEtParagraphe, "control S");
        this.raccourciClavierEltMenu(fenPrincipale.eltmenu_ficVisualiserParagraphe, "control O");
        this.raccourciClavierEltMenu(fenPrincipale.eltmenu_ficQuitter, "control Q");
        this.clicGaucheEltsMenu(fenPrincipale.menu_navigation);
        this.raccourciClavierEltMenu(fenPrincipale.eltmenu_navigChoisirCivilisation, "control R");
        this.raccourciClavierEltMenu(fenPrincipale.eltmenu_navigChoisirDate, "control D");
        this.raccourciClavierEltMenu(fenPrincipale.eltmenu_navigChoisirCentre, "control P");
        this.clicGaucheEltsMenu(fenPrincipale.menu_affichage);
        this.raccourciClavierEltMenu(fenPrincipale.eltmenu_affFleuvesVisibles, "control F");
        this.raccourciClavierEltMenu(fenPrincipale.eltmenu_affMeridiensParallelesVisibles, "control M");
        this.raccourciClavierEltMenu(fenPrincipale.eltmenu_affChoixLoupe, "control L");
        this.clicGaucheEltsMenu(fenPrincipale.menu_options);
        this.clicGaucheEltsMenu(fenPrincipale.menu_aide);
        this.raccourciClavierEltMenu(fenPrincipale.eltmenu_aidePresentation, "F1");
        this.clicGaucheEltsMenu(fenPrincipale.menu_deplAnnees);
        this.clicGaucheEltsMenu(fenPrincipale.menu_deplEspace);
        this.clicGaucheEltsMenu(fenPrincipale.menu_parametres);
        this.clicGaucheEltsMenu(fenPrincipale.menuctx_deplAnnees);
        this.clicGaucheEltsMenu(fenPrincipale.menuctx_deplEspace);
        this.pressionGauche(fenPrincipale.p_carte);
        this.clicGauche(fenPrincipale.p_carte);
        this.clicDroit(fenPrincipale.p_carte);
        this.clicDroitMaj(fenPrincipale.p_carte);
        this.glissement(fenPrincipale.p_carte);
        this.mouvement(fenPrincipale.p_carte);
        this.sortie(fenPrincipale.p_carte);
        this.redimensionnement(fenPrincipale.p_carte);
        this.changementValeur(fenPrincipale.defil_longitudes);
        this.changementValeur(fenPrincipale.defil_latitudes);
        this.clicDroit(fenPrincipale.defil_longitudes);
        this.clicDroit(fenPrincipale.defil_latitudes);
        this.changementEtat(fenPrincipale.defil_annees);
        this.clicDroit(fenPrincipale.defil_annees);
        this.clicGauche(fenPrincipale.p_navigateur.cc_suiviCivilisation);
        this.fermetureFenetre(fenPrincipale);
    }

    public void declarerCapturesEvenementsParagrapheHtml(ParagrapheNavig paragrapheNavig) {
        paragrapheNavig.addMouseListener(new EcouteurClicGauche(paragrapheNavig, this));
        paragrapheNavig.addMouseListener(new EcouteurClicDroit(paragrapheNavig, this));
    }

    public void declarerCapturesEvenementsDialLoupe(DialLoupe dialLoupe) {
        this.dialLoupe = dialLoupe;
        this.changementEtat(dialLoupe.barre);
        this.clicGauche(dialLoupe.btnOK);
        this.clicGauche(dialLoupe.btnAnnul);
        this.fermetureDialogue(dialLoupe);
    }

    public void declarerCapturesEvenementsDialAnnee(DialAnnee dialAnnee) {
        this.dialAnnee = dialAnnee;
        this.clicGauche(dialAnnee.btnOK);
        this.clicGauche(dialAnnee.btnAnnul);
        this.fermetureDialogue(dialAnnee);
    }

    public void declarerCapturesEvenementsDialCentre(DialCentre dialCentre) {
        this.dialCentre = dialCentre;
        this.changementEtat(dialCentre.barreLongitude);
        this.changementEtat(dialCentre.barreLatitude);
        this.clicGauche(dialCentre.btnOK);
        this.clicGauche(dialCentre.btnAnnul);
        this.fermetureDialogue(dialCentre);
    }

    @Override
    public void traiterEvenement(Evenement evenement) {
        Window window;
        int n;
        Evenement.TypeEvt typeEvt = evenement.typeEvt();
        Component component = evenement.composant();
        Object object = evenement.evtComplet().getSource();
        EventObject eventObject = evenement.evtComplet();
        Object object2 = eventObject.getSource() instanceof ConteneurValeur ? ((ConteneurValeur)eventObject.getSource()).valeur() : null;
        int n2 = eventObject instanceof MouseEvent ? ((MouseEvent)eventObject).getX() : -1;
        int n3 = n = eventObject instanceof MouseEvent ? ((MouseEvent)eventObject).getY() : -1;
        if (this.fenPrincipale != null) {
            window = this.fenPrincipale;
            PanCarte panCarte = this.fenPrincipale.p_carte;
            PanNavigateur panNavigateur = this.fenPrincipale.p_navigateur;
            if (typeEvt == Evenement.TypeEvt.PRESSION_GAUCHE && component == ((FenPrincipale)window).bt_loupe) {
                ActionsEspaceTemps.augmenterLoupe();
            }
            if (typeEvt == Evenement.TypeEvt.PRESSION_DROIT && component == ((FenPrincipale)window).bt_loupe) {
                ActionsEspaceTemps.diminuerLoupe();
            }
            if (typeEvt == Evenement.TypeEvt.MOLETTE_SOURIS && component == ((FenPrincipale)window).p_carte) {
                ActionsEspaceTemps.decalerLoupe(-((MouseWheelEvent)eventObject).getWheelRotation());
            }
            if (typeEvt == Evenement.TypeEvt.CLIC_GAUCHE && component == ((FenPrincipale)window).txt_loupe) {
                ActionsEspaceTemps.affDialChoixLoupe();
            }
            if (typeEvt == Evenement.TypeEvt.CLIC_GAUCHE && component == ((FenPrincipale)window).txt_annee) {
                ActionsFenetres.affDialChoixDate();
            }
            if (typeEvt == Evenement.TypeEvt.CLIC_GAUCHE && component == ((FenPrincipale)window).txt_pointCentral) {
                ActionsEspaceTemps.affDialChoixCentre();
            }
            if (typeEvt == Evenement.TypeEvt.CLIC_GAUCHE_ELT_MENU && object == ((FenPrincipale)window).eltmenu_ficReinitValeurs) {
                ActionsGeneralesAppli.revenirAuxValeursInitiales();
            }
            if (typeEvt == Evenement.TypeEvt.CLIC_GAUCHE_ELT_MENU && object == ((FenPrincipale)window).eltmenu_ficExporterCarte) {
                ActionsCarte.sauvegarderCarte();
            }
            if (typeEvt == Evenement.TypeEvt.CLIC_GAUCHE_ELT_MENU && object == ((FenPrincipale)window).eltmenu_ficExporterCarteEtParagraphe) {
                ActionsCarte.sauvegarderCarteEtParagraphe();
            }
            if (typeEvt == Evenement.TypeEvt.CLIC_GAUCHE_ELT_MENU && object == ((FenPrincipale)window).eltmenu_ficVisualiserParagraphe) {
                ActionsCarte.visualiserParagraphe();
            }
            if (typeEvt == Evenement.TypeEvt.CLIC_GAUCHE_ELT_MENU && object == ((FenPrincipale)window).eltmenu_ficQuitter) {
                ActionsGeneralesAppli.sauverEtatEtQuitter();
            }
            if (typeEvt == Evenement.TypeEvt.CLIC_GAUCHE_ELT_MENU && object == ((FenPrincipale)window).eltmenu_navigChoisirCivilisation) {
                ActionsFenetres.affDialChoixCivilisation();
            }
            if (typeEvt == Evenement.TypeEvt.CLIC_GAUCHE_ELT_MENU && object == ((FenPrincipale)window).eltmenu_navigChoisirDate) {
                ActionsFenetres.affDialChoixDate();
            }
            if (typeEvt == Evenement.TypeEvt.CLIC_GAUCHE_ELT_MENU && object == ((FenPrincipale)window).eltmenu_navigChoisirCentre) {
                ActionsEspaceTemps.affDialChoixCentre();
            }
            if (typeEvt == Evenement.TypeEvt.CLIC_GAUCHE_ELT_MENU && object == ((FenPrincipale)window).eltmenu_affFleuvesVisibles) {
                ActionsOptionsGraphiques.inverserFleuvesVisibles();
            }
            if (typeEvt == Evenement.TypeEvt.CLIC_GAUCHE_ELT_MENU && object == ((FenPrincipale)window).eltmenu_affMeridiensParallelesVisibles) {
                ActionsOptionsGraphiques.inverserMeridiensParallelesVisibles();
            }
            if (typeEvt == Evenement.TypeEvt.CLIC_GAUCHE_ELT_MENU && object == ((FenPrincipale)window).eltmenu_optInfobullesCarte) {
                ActionsOptionsGraphiques.inverserInfobullesCarte();
            }
            if (typeEvt == Evenement.TypeEvt.CLIC_GAUCHE_ELT_MENU && object == ((FenPrincipale)window).eltmenu_optSymboleTracer) {
                ActionsOptionsGraphiques.inverserSymboleTracer();
            }
            if (typeEvt == Evenement.TypeEvt.CLIC_GAUCHE_ELT_MENU && object == ((FenPrincipale)window).eltmenu_optTexteSurvolFondClair) {
                ActionsOptionsGraphiques.inverserTexteSurvolFondClair();
            }
            if (typeEvt == Evenement.TypeEvt.CLIC_GAUCHE_ELT_MENU && object == ((FenPrincipale)window).eltmenu_optSimpleClicFermerParagraphes) {
                ActionsOptionsGraphiques.inverserSimpleClicFermerParagraphes();
            }
            if (typeEvt == Evenement.TypeEvt.CLIC_GAUCHE_ELT_MENU && object == ((FenPrincipale)window).eltmenu_optMoletteGlisseDeUn) {
                ActionsOptionsGraphiques.inverserMoletteGlisseDeUn();
            }
            if (typeEvt == Evenement.TypeEvt.CLIC_GAUCHE_ELT_MENU && object == ((FenPrincipale)window).eltmenu_optAffParagraphesHtmlGeneres) {
                ActionsOptionsGraphiques.inverserAffParagraphesHtmlGeneres();
            }
            if (typeEvt == Evenement.TypeEvt.CLIC_GAUCHE_ELT_MENU && object == ((FenPrincipale)window).eltmenu_affChoixLoupe) {
                ActionsEspaceTemps.affDialChoixLoupe();
            }
            if (typeEvt == Evenement.TypeEvt.CLIC_GAUCHE_ELT_MENU && component == ((FenPrincipale)window).menu_deplAnnees) {
                ActionsOptionsGraphiques.modifierPasDeplAnnees((Integer)object2);
            }
            if (typeEvt == Evenement.TypeEvt.CLIC_GAUCHE_ELT_MENU && component == ((FenPrincipale)window).menu_deplEspace) {
                ActionsOptionsGraphiques.modifierPasDeplEspace((Integer)object2);
            }
            if (typeEvt == Evenement.TypeEvt.CLIC_GAUCHE_ELT_MENU && object == ((FenPrincipale)window).eltmenu_aidePresentation) {
                ActionsFenetres.affFenPresentation();
            }
            if (typeEvt == Evenement.TypeEvt.CLIC_GAUCHE_ELT_MENU && object == ((FenPrincipale)window).eltmenu_aideAPropos) {
                ActionsFenetres.affDialAPropos();
            }
            if (typeEvt == Evenement.TypeEvt.CLIC_GAUCHE_ELT_MENU && component == ((FenPrincipale)window).menuctx_deplAnnees) {
                ActionsOptionsGraphiques.modifierPasDeplAnnees((Integer)object2);
            }
            if (typeEvt == Evenement.TypeEvt.CLIC_GAUCHE_ELT_MENU && component == ((FenPrincipale)window).menuctx_deplEspace) {
                ActionsOptionsGraphiques.modifierPasDeplEspace((Integer)object2);
            }
            if (typeEvt == Evenement.TypeEvt.PRESSION_GAUCHE && component == panCarte) {
                ActionsCarte.reinitialiserTerritoireSurvole();
            }
            if (typeEvt == Evenement.TypeEvt.PRESSION_GAUCHE && component == panCarte) {
                ActionsCarte.reinitialiserInfobullesPanneau();
            }
            if (typeEvt == Evenement.TypeEvt.PRESSION_GAUCHE && component == panCarte) {
                ActionsCarte.centrerCarteSiNonTexteSur(n2, n);
            }
            if (typeEvt == Evenement.TypeEvt.PRESSION_GAUCHE && component == panCarte) {
                ActionsCarte.initierDeplacementTexteTerritoireEn(n2, n);
            }
            if (typeEvt == Evenement.TypeEvt.CLIC_GAUCHE && component == panCarte) {
                ActionsCarte.centrerCarteSiOrigineTexteSur(n2, n);
            }
            if (typeEvt == Evenement.TypeEvt.CLIC_DROIT && component == panCarte) {
                ActionsCarte.affParagrapheTerritoireEn(n2, n);
            }
            if (typeEvt == Evenement.TypeEvt.CLIC_DROIT_MAJUSCULE && component == panCarte) {
                ActionsCarte.affDialVisibiliteTerritoireEn(n2, n);
            }
            if (typeEvt == Evenement.TypeEvt.GLISSEMENT_SOURIS && component == panCarte) {
                ActionsCarte.deplacerTexteTerritoire(n2, n);
            }
            if (typeEvt == Evenement.TypeEvt.MOUVEMENT_SOURIS && component == panCarte) {
                ActionsCarte.definirTerritoireSurvole(n2, n);
            }
            if (typeEvt == Evenement.TypeEvt.MOUVEMENT_SOURIS && component == panCarte) {
                ActionsCarte.ajusterInfobullesPanneau(n2, n);
            }
            if (typeEvt == Evenement.TypeEvt.SORTIE_SOURIS && component == panCarte) {
                ActionsCarte.reinitialiserTerritoireSurvole();
            }
            if (typeEvt == Evenement.TypeEvt.SORTIE_SOURIS && component == panCarte) {
                ActionsCarte.reinitialiserInfobullesPanneau();
            }
            if (typeEvt == Evenement.TypeEvt.REDIMENSIONNEMENT && component == panCarte) {
                ActionsCarte.modifierTailleDispoPourCarte();
            }
            if (typeEvt == Evenement.TypeEvt.CHANGEMENT_VALEUR && component == ((FenPrincipale)window).defil_longitudes) {
                ActionsEspaceTemps.modifierLongitude((double)((JScrollBar)component).getValue() / (double)FenPrincipale.MULTIPLICATEUR_ESPACE);
            }
            if (typeEvt == Evenement.TypeEvt.CHANGEMENT_VALEUR && component == ((FenPrincipale)window).defil_latitudes) {
                ActionsEspaceTemps.modifierLatitude(-((double)((JScrollBar)component).getValue()) / (double)FenPrincipale.MULTIPLICATEUR_ESPACE);
            }
            if (typeEvt == Evenement.TypeEvt.CLIC_DROIT && component == ((FenPrincipale)window).defil_longitudes) {
                ActionsFenetres.affMenuContextuelDeplEspace(((FenPrincipale)window).defil_longitudes, n2, n);
            }
            if (typeEvt == Evenement.TypeEvt.CLIC_DROIT && component == ((FenPrincipale)window).defil_latitudes) {
                ActionsFenetres.affMenuContextuelDeplEspace(((FenPrincipale)window).defil_latitudes, n2, n);
            }
            if (typeEvt == Evenement.TypeEvt.CHANGEMENT_ETAT && component == ((FenPrincipale)window).defil_annees) {
                ActionsEspaceTemps.modifierAnnee(((GlissiereDates)component).getValeur());
            }
            if (typeEvt == Evenement.TypeEvt.CLIC_DROIT && component == ((FenPrincipale)window).defil_annees) {
                ActionsFenetres.affMenuContextuelDeplAnnees(((FenPrincipale)window).defil_annees, n2, n);
            }
            if (typeEvt == Evenement.TypeEvt.CLIC_GAUCHE && component == panNavigateur.cc_suiviCivilisation) {
                ActionsNavigateur.modifierSuiviCivilisation((Boolean)object2);
            }
            if (typeEvt == Evenement.TypeEvt.CLIC_GAUCHE && component instanceof ParagrapheNavig) {
                ActionsNavigateur.naviguer((ParagrapheNavig)component, new Point(n2, n));
            }
            if (typeEvt == Evenement.TypeEvt.CLIC_DROIT && component instanceof ParagrapheNavig) {
                ActionsNavigateur.affVueCorrespondante(((ParagrapheNavig)component).paragraphe());
            }
            if (typeEvt == Evenement.TypeEvt.FERMETURE_FENETRE && component == window) {
                ActionsGeneralesAppli.sauverEtatEtQuitter();
            }
        }
        if (this.dialLoupe != null) {
            window = this.dialLoupe;
            if (typeEvt == Evenement.TypeEvt.CHANGEMENT_ETAT && component == ((DialLoupe)window).barre) {
                ActionsEspaceTemps.modifierLoupe(((DialLoupe)window).barre.getValeur());
            }
            if (typeEvt == Evenement.TypeEvt.CLIC_GAUCHE && component == ((DialLoupe)window).btnOK) {
                ActionsEspaceTemps.validerChangementLoupe();
            }
            if (typeEvt == Evenement.TypeEvt.CLIC_GAUCHE && component == ((DialLoupe)window).btnAnnul) {
                ActionsEspaceTemps.annulerChangementLoupe();
            }
            if (typeEvt == Evenement.TypeEvt.FERMETURE_FENETRE && component == window) {
                ActionsEspaceTemps.annulerChangementLoupe();
            }
        }
        if (this.dialAnnee != null) {
            window = this.dialAnnee;
            if (typeEvt == Evenement.TypeEvt.CLIC_GAUCHE && component == ((DialAnnee)window).btnOK) {
                ActionsEspaceTemps.validerChangementDate();
            }
            if (typeEvt == Evenement.TypeEvt.CLIC_GAUCHE && component == ((DialAnnee)window).btnAnnul) {
                ActionsEspaceTemps.annulerChangementDate();
            }
            if (typeEvt == Evenement.TypeEvt.FERMETURE_FENETRE && component == window) {
                ActionsEspaceTemps.annulerChangementDate();
            }
        }
        if (this.dialCentre != null) {
            window = this.dialCentre;
            if (typeEvt == Evenement.TypeEvt.CHANGEMENT_ETAT && component == ((DialCentre)window).barreLongitude) {
                ((DialCentre)window).modifierLongitude();
            }
            if (typeEvt == Evenement.TypeEvt.CHANGEMENT_ETAT && component == ((DialCentre)window).barreLatitude) {
                ((DialCentre)window).modifierLatitude();
            }
            if (typeEvt == Evenement.TypeEvt.CLIC_GAUCHE && component == ((DialCentre)window).btnOK) {
                ActionsEspaceTemps.validerChangementCentre();
            }
            if (typeEvt == Evenement.TypeEvt.CLIC_GAUCHE && component == ((DialCentre)window).btnAnnul) {
                ActionsEspaceTemps.annulerChangementCentre();
            }
            if (typeEvt == Evenement.TypeEvt.FERMETURE_FENETRE && component == window) {
                ActionsEspaceTemps.annulerChangementCentre();
            }
        }
    }
}

