/*
 * Decompiled with CFR 0.152.
 */
package fr.histoiremondiale.histoire.utiles.math;

import fr.histoiremondiale.histoire.utiles.math.Matrice;
import fr.histoiremondiale.histoire.utiles.math.PointEspace;
import fr.histoiremondiale.histoire.utiles.math.PointPlan;
import fr.histoiremondiale.histoire.utiles.math.PointSphere;

public class CalculsEspace {
    public static double produitScalaire(PointEspace pointEspace, PointEspace pointEspace2, PointEspace pointEspace3) {
        return (pointEspace2.x() - pointEspace.x()) * (pointEspace3.x() - pointEspace.x()) + (pointEspace2.y() - pointEspace.y()) * (pointEspace3.y() - pointEspace.y()) + (pointEspace2.z() - pointEspace.z()) * (pointEspace3.z() - pointEspace.z());
    }

    public static PointEspace multiplier(Matrice matrice, PointEspace pointEspace) {
        double d = matrice.val(1, 1) * pointEspace.x() + matrice.val(1, 2) * pointEspace.y() + matrice.val(1, 3) * pointEspace.z();
        double d2 = matrice.val(2, 1) * pointEspace.x() + matrice.val(2, 2) * pointEspace.y() + matrice.val(2, 3) * pointEspace.z();
        double d3 = matrice.val(3, 1) * pointEspace.x() + matrice.val(3, 2) * pointEspace.y() + matrice.val(3, 3) * pointEspace.z();
        return new PointEspace(d, d2, d3);
    }

    public static PointEspace ptEspaceDepuisPtSphere(PointSphere pointSphere) {
        double d = Math.cos(Math.toRadians(pointSphere.longitude()));
        double d2 = Math.cos(Math.toRadians(pointSphere.latitude()));
        double d3 = Math.sin(Math.toRadians(pointSphere.longitude()));
        double d4 = Math.sin(Math.toRadians(pointSphere.latitude()));
        return new PointEspace(d * d2, d3 * d2, d4);
    }

    public static PointPlan projection(PointEspace pointEspace, double d, double d2) {
        double d3;
        double d4 = 30.0;
        double d5 = Math.cos(Math.toRadians(d4));
        double d6 = Math.sin(Math.toRadians(d4));
        double d7 = d3 = d2 * d5 / (2.0 * d6);
        double d8 = pointEspace.x();
        if (d8 <= 0.0) {
            d8 = 1.0E-6;
        }
        double d9 = d3 * d * pointEspace.y() / d8;
        double d10 = d7 * d * pointEspace.z() / d8;
        return new PointPlan(d9, d10);
    }
}

