/*
 * Decompiled with CFR 0.152.
 */
package fr.histoiremondiale.histoire.utiles.math;

import fr.histoiremondiale.histoire.utiles.exttypes.Chaines;
import java.text.DecimalFormat;

public class PointSphere {
    private double longitude;
    private double latitude;
    private double cosLo = Double.NaN;
    private double cosLa = Double.NaN;
    private double sinLo = Double.NaN;
    private double sinLa = Double.NaN;
    private Integer valHachage = null;
    private static final double rapportConversionHachge = 364.0888888888889;

    public PointSphere(double d, double d2) {
        this.longitude = d;
        this.latitude = d2;
    }

    public String toString() {
        return this.enChaineElaboree();
    }

    public String enChaineSimple() {
        return "(lo=" + new DecimalFormat("#0.00").format(this.longitude) + "\u00b0, la=" + new DecimalFormat("#0.00").format(this.latitude) + "\u00b0)";
    }

    public String enChaineElaboree() {
        return "(" + new DecimalFormat("#0.00").format(Math.abs(this.latitude)) + "\u00b0 " + (this.latitude < 0.0 ? "Sud" : "Nord") + " ; " + new DecimalFormat("#0.00").format(Math.abs(this.longitude)) + "\u00b0 " + (this.longitude < 0.0 ? "Ouest" : "Est") + ")";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        PointSphere pointSphere = (PointSphere)object;
        return this.longitude == pointSphere.longitude && this.latitude == pointSphere.latitude;
    }

    public int hashCode() {
        if (this.valHachage == null) {
            int n = new Double(this.longitude * 364.0888888888889).intValue();
            int n2 = new Double(this.latitude * 364.0888888888889).intValue();
            this.valHachage = n << 16 | n2 & 0xFFFF;
        }
        return this.valHachage;
    }

    public double longitude() {
        return this.longitude;
    }

    public double latitude() {
        return this.latitude;
    }

    public double getCosLo() {
        if (Double.isNaN(this.cosLo)) {
            this.cosLo = Math.cos(Math.toRadians(this.longitude));
        }
        return this.cosLo;
    }

    public double getCosLa() {
        if (Double.isNaN(this.cosLa)) {
            this.cosLa = Math.cos(Math.toRadians(this.latitude));
        }
        return this.cosLa;
    }

    public double getSinLo() {
        if (Double.isNaN(this.sinLo)) {
            this.sinLo = Math.sin(Math.toRadians(this.longitude));
        }
        return this.sinLo;
    }

    public double getSinla() {
        if (Double.isNaN(this.sinLa)) {
            this.sinLa = Math.sin(Math.toRadians(this.latitude));
        }
        return this.sinLa;
    }

    public boolean DansLeCercle(PointSphere pointSphere, double d) {
        return this.cosArcAB(pointSphere) >= d;
    }

    public double cosArcAB(PointSphere pointSphere) {
        double d = Math.cos(Math.toRadians(this.latitude()));
        double d2 = Math.cos(Math.toRadians(pointSphere.latitude()));
        double d3 = Math.cos(Math.toRadians(this.longitude() - pointSphere.longitude()));
        double d4 = Math.sin(Math.toRadians(this.latitude()));
        double d5 = Math.sin(Math.toRadians(pointSphere.latitude()));
        return d * d2 * d3 + d4 * d5;
    }

    public boolean voisin(double d, PointSphere pointSphere, double d2) {
        double d3;
        double d4;
        double d5 = Math.acos(this.cosArcAB(pointSphere));
        return d5 < (d4 = Math.acos(d)) + (d3 = Math.acos(d2));
    }

    public boolean proche(PointSphere pointSphere, double d) {
        double d2 = Math.acos(this.cosArcAB(pointSphere));
        return d2 < d;
    }

    public static PointSphere parsePointSphere(String string) {
        String string2 = string;
        if (string2.contains("lo=")) {
            double d = Double.parseDouble(Chaines.entreMarqueurs(string2, "lo=", "\u00b0").replace(",", "."));
            double d2 = Double.parseDouble(Chaines.entreMarqueurs(string2, "la=", "\u00b0").replace(",", "."));
            return new PointSphere(d, d2);
        }
        if (string2.contains("\u00b0")) {
            double d = Double.parseDouble(Chaines.entreMarqueurs(string2, "(", "\u00b0").replace(",", "."));
            String string3 = Chaines.avantMarqueur(string2 = Chaines.apresMarqueur(string2, "\u00b0 "), ",");
            if (!string3.equals("Nord")) {
                if (string3.equals("Sud")) {
                    d = -d;
                } else {
                    throw new IllegalArgumentException("La cha\u00eene ne correspond pas \u00e0 un PointSphere (la direction devrait \u00eatre Nord ou Sud) : \"" + string + "\"");
                }
            }
            string2 = Chaines.apresMarqueur(string2, ", ");
            double d3 = Double.parseDouble(Chaines.avantMarqueur(string2, "\u00b0").replace(",", "."));
            string3 = Chaines.avantMarqueur(string2 = Chaines.apresMarqueur(string2, "\u00b0 "), ")");
            if (!string3.equals("Est")) {
                if (string3.equals("Ouest")) {
                    d3 = -d3;
                } else {
                    throw new IllegalArgumentException("La cha\u00eene ne correspond pas \u00e0 un PointSphere (la direction devrait \u00eatre Est ou Ouest) : \"" + string + "\"");
                }
            }
            return new PointSphere(d3, d);
        }
        throw new IllegalArgumentException("La cha\u00eene ne correspond pas \u00e0 un PointSphere : \"" + string + "\"");
    }

    public void longitude(double d) {
        this.longitude = d;
    }

    public void latitude(double d) {
        this.latitude = d;
    }

    public boolean egal(PointSphere pointSphere) {
        return pointSphere.longitude() == this.longitude && pointSphere.latitude() == this.latitude;
    }
}

