#!/bin/bash

set -e

if [ "$#" !=  "3" ]
then
    echo "Le script attend des paramètres (exemple : 'programme-2.1' '/chemin/programme-2.1-src.tar.gz' '/chemin/destination/paquet/')"
    exit 1
fi

NOM_BASE_ARCHIVE="$1"
CHEM_ARCHIVE_SOURCE="$2"
CHEM_DESTINATION_PAQUET="$3"
REP_COMPILATION=compilation-paquet--tmp--
NOM_PAQUET=$NOM_BASE_ARCHIVE

# Créer les répertoires
rm -rf $REP_COMPILATION
mkdir $REP_COMPILATION
mkdir $REP_COMPILATION/preparation
mkdir $REP_COMPILATION/$NOM_PAQUET
mkdir $REP_COMPILATION/$NOM_PAQUET/DEBIAN

# Extraire l'archive et compiler le logiciel
cp $CHEM_ARCHIVE_SOURCE $REP_COMPILATION/preparation/
cd $REP_COMPILATION/preparation
tar -xf $NOM_BASE_ARCHIVE-src.tar.gz
cd $NOM_BASE_ARCHIVE-src
make
cd ../../..

# Rassembler les informations pour créer le paquet
# (installer le logiciel dans un répertoire virtuel et ajouter les méta-données)
cd $REP_COMPILATION/preparation/$NOM_BASE_ARCHIVE-src
DESTDIR=../../$NOM_PAQUET make install
cd ../../..
cp control $REP_COMPILATION/$NOM_PAQUET/DEBIAN

# Créer le paquet
cd $REP_COMPILATION
dpkg-deb --build $NOM_PAQUET
cd ..
cp $REP_COMPILATION/$NOM_PAQUET.deb $CHEM_DESTINATION_PAQUET

# Nettoyer le répertoire temporaire
rm -rf $REP_COMPILATION
