/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire;

import java.awt.image.BufferedImage ;
import java.io.File ;
import java.io.IOException ;
import java.util.HashMap ;
import java.util.Map ;

import javax.imageio.ImageIO ;
import javax.swing.Icon ;
import javax.swing.ImageIcon ;




/**
 * Classe permettant d'accéder aux ressources (images, ...) de l'application.
 */
public class RessourcesAppli
{
    
    // Constantes
    // (icônes)
    public static String ICONE_APPLI_32            = "terre32.png" ;
    public static String ICONE_LOUPE               = "loupe.png" ;
    public static String ICONE_PLUME               = "plume.png" ;
    // (icônes des licences)
    public static String ICONE_LICENCE_CODE_SOURCE = "agplv3_88x31.png" ;
    public static String ICONE_LICENCE_DONNEES     = "cc-by-sa_88x31.png" ;
    public static String ICONE_LICENCE_ICONES      = "lal_80x15.gif" ;
    

    private static Map<String,Icon>          cacheIcones               = new HashMap<>() ;
    private static Map<String,BufferedImage> cacheIconesImages         = new HashMap<>() ;
    private static Map<String,BufferedImage> cacheIconesLicencesImages = new HashMap<>() ;
    
    
    
    /**
     * Renvoie l'icône dont le nom de fichier est passé en paramètre.
     * @param nomIcone Nom du fichier de l'icône.
     * @return L'icône correspondante.
     */
    public static Icon icone (String nomIcone)
    {
        // Regarder dans le cache
        Icon iconeCache = cacheIcones.get (nomIcone) ;
        if (iconeCache != null)
            return iconeCache ;
        
        // Charger l'icône depuis son fichier
        String chemRepIcones = HistoireMondiale.instance().config().chemRepIcones() ;
        Icon iconeChargee = new ImageIcon (chemRepIcones + File.separator + nomIcone) ;

        // Garder l'icône en cache et la renvoyer
        cacheIcones.put (nomIcone, iconeChargee) ;
        return iconeChargee ;
    }
    
    
    /**
     * Renvoie l'icône dont le nom de fichier est passé en paramètre.<br>
     * L'icône est renvoyée sous forme d'une image.
     * @param nomIcone Nom du fichier de l'icône.
     * @return L'image représentant l'icône.
     */
    public static BufferedImage imageIcone (String nomIcone)
    {
        // Regarder dans le cache
        BufferedImage iconeCache = cacheIconesImages.get (nomIcone) ;
        if (iconeCache != null)
            return iconeCache ;
        
        // Charger l'icône depuis son fichier
        String chemRepIcones = HistoireMondiale.instance().config().chemRepIcones() ;
        String chemFicIcone  = chemRepIcones + File.separator + nomIcone ;
        BufferedImage  iconeChargee ;
        try
        {
            iconeChargee = ImageIO.read (new File (chemFicIcone)) ;
        }
        catch (IOException e)
        {
            e.printStackTrace() ;
            System.err.println ("Erreur de chargement de l'icône : \"" + chemFicIcone + "\"") ;
            return null ;
        }

        // Garder l'icône en cache et la renvoyer
        cacheIconesImages.put (nomIcone, iconeChargee) ;
        return iconeChargee ;
    }

    
    /**
     * Renvoie l'icône de licence dont le nom de fichier est passé en paramètre.<br>
     * L'icône est renvoyée sous forme d'une image.
     * @param nomIcone Nom du fichier de l'icône.
     * @return L'image représentant l'icône.
     */
    public static BufferedImage imageIconeLicence (String nomIcone)
    {
        // Regarder dans le cache
        BufferedImage iconeCache = cacheIconesLicencesImages.get (nomIcone) ;
        if (iconeCache != null)
            return iconeCache ;
        
        // Charger l'icône depuis son fichier
        String chemRepIcones = HistoireMondiale.instance().config().chemRepIconesLicences() ;
        String chemFicIcone  = chemRepIcones + File.separator + nomIcone ;
        BufferedImage  iconeChargee ;
        try
        {
            iconeChargee = ImageIO.read (new File (chemFicIcone)) ;
        }
        catch (IOException e)
        {
            e.printStackTrace() ;
            System.err.println ("Erreur de chargement de l'icône de licence : \"" + chemFicIcone + "\"") ;
            return null ;
        }

        // Garder l'icône en cache et la renvoyer
        cacheIconesLicencesImages.put (nomIcone, iconeChargee) ;
        return iconeChargee ;
    }
    
}
