/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire.donnees;

import java.util.ArrayList;
import java.util.List ;

import fr.histoiremondiale.histoire.utiles.math.PointSphere;







/**
 * Suite de points (nom issu des limes de l'Empire Romain, mais on ne parle pas de fortifications ici).
 */
public class Limes
{

    private List<PointSphere> points ;      // Points du limes.

    
    /**
     * Constructeur.
     * @param points Points constituant le limes.
     */
    public Limes (List<PointSphere> points)
    {
        this.points = points ;
    }
    
    public Limes()
    {
    	points = new ArrayList<>();
    }
    
    // Accesseurs
    public List<PointSphere> points () { return this.points ; }
    
}
