/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire.igraphique;
import java.awt.BorderLayout;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

import fr.histoiremondiale.histoire.igraphique.actions.ActionsEspaceTemps;
import fr.histoiremondiale.histoire.igraphique.composants.Barre;
import fr.histoiremondiale.histoire.utiles.igraphique.swing.Fenetres;
import fr.histoiremondiale.histoire.utiles.math.PointSphere;

public class DialCentre extends JDialog
{
	private double longitude, latitude;
	private PointSphere centreInitial;
	private JLabel lbl;
	public  Barre barreLongitude;
	public  Barre barreLatitude;
	public JButton btnOK;
	public JButton btnAnnul;
	
	public DialCentre(JFrame parent, PointSphere centre)
	{
		super(parent, "Centre", true);
		this.longitude = centre.longitude();
		this.latitude = centre.latitude();
		this.centreInitial = centre;
		
		initComponent();
		pack();
		Fenetres.centrer(this, parent);
		Fenetres.ajouterEcouteurEchapPourMasquer(this);
		
	}
	
	public DialCentre(JFrame parent, String titre) 
	{
		super(parent, titre, true);
		this.centreInitial = new PointSphere(longitude, latitude);
		initComponent();
		pack();
		Fenetres.centrer(this, parent);
		Fenetres.ajouterEcouteurEchapPourMasquer(this);
	}

	private void initComponent() 
	{
		JPanel contenant = new JPanel();
		contenant.setLayout(new BorderLayout(5, 5));
		
		JPanel panelValeurInitiale = new JPanel();
		lbl = new JLabel(centreInitial.enChaineElaboree());
		panelValeurInitiale.add(lbl);
		panelValeurInitiale.setBorder(BorderFactory.createTitledBorder("Valeur initiale"));
		
		JPanel panelLongitude = new JPanel();
		panelLongitude.setLayout(new BoxLayout(panelLongitude, BoxLayout.Y_AXIS));
		barreLongitude = new Barre(-180,180,longitude);
		barreLongitude.setLargeur(80);
		panelLongitude.add(barreLongitude);
		panelLongitude.setBorder(BorderFactory.createTitledBorder("Longitude"));
		
		
		JPanel panelLatitude = new JPanel();
		panelLatitude.setLayout(new BoxLayout(panelLatitude, BoxLayout.Y_AXIS));
		barreLatitude = new Barre(-90,90, latitude);
		barreLatitude.setLargeur(80);
		panelLatitude.add(barreLatitude);
		panelLatitude.setBorder(BorderFactory.createTitledBorder("Latitude"));
		
		JPanel controle = new JPanel();
		btnOK = new JButton("Valider");
		btnAnnul = new JButton("Annuler");
		controle.add(btnOK);
		controle.add(btnAnnul);

		contenant.add(panelValeurInitiale, BorderLayout.NORTH);
		contenant.add(panelLongitude, BorderLayout.EAST);
		contenant.add(panelLatitude, BorderLayout.WEST);
		contenant.add(controle, BorderLayout.SOUTH);
		
		getContentPane().add(contenant);
	}

	public void afficher(PointSphere ptCentralCarte) 
	{
		longitude = ptCentralCarte.longitude();
		latitude = ptCentralCarte.latitude();
		centreInitial = ptCentralCarte;
    	this.barreLongitude.setValeur(longitude);
    	this.barreLatitude.setValeur(latitude);
    	this.setVisible(true);
	}

	public PointSphere getCentreInitial() 
	{
		return centreInitial;
	}

	public void modifierLongitude() 
	{
		longitude = barreLongitude.getValeur();
		lbl.setText(new PointSphere(longitude, latitude).enChaineElaboree());
		ActionsEspaceTemps.modifierLongitude (longitude) ;
	}
	
	public void modifierLatitude()
	{
		latitude = barreLatitude.getValeur();
		lbl.setText(new PointSphere(longitude, latitude).enChaineElaboree());
		ActionsEspaceTemps.modifierLatitude (latitude) ;
	}

}
