/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire.igraphique;

import java.awt.Dimension ;

import javax.swing.JEditorPane ;

import fr.histoiremondiale.histoire.igraphique.donnees.InfosParagrapheNavig;



/**
 * Paragraphe affiché dans le navigateur html, avec les informations sur le paragraphe.
 */
public class ParagrapheNavig extends JEditorPane
{

    private InfosParagrapheNavig paragraphe ;       // Informations sur le Paragraphe
    private Integer              largeur ;          // Largeur imposée (null si aucune)
   
    
    
    /**
     * Constructeur.
     * @param paragraphe Les informations sur le paragraphe représenté par ce composant graphique.
     */
    public ParagrapheNavig (InfosParagrapheNavig paragraphe)
    {
        this.paragraphe  = paragraphe ;
    }
    
    
    // Accesseurs
    public InfosParagrapheNavig paragraphe ()
    {
        return this.paragraphe ;
    }
    
    
    // Méthode permettant de fixer la largeur du panneau.
    // Si une largeur a été spécifiée pour le panneau, elle est considérée comme la largeur à indiquer
    //   quand on demande la taille préférée du composant.
    public void modifLargeur (Integer largeur)
    {
        this.largeur = largeur ;
    }
    // (attention, peut renvoyer null, bien regarder ce que veut dire cette valeur)
    public Integer largeur ()
    {
        return this.largeur ;
    }
    public Dimension getPreferredSize ()
    {
        Dimension taillePreferee = super.getPreferredSize() ;
        return (this.largeur == null ?
                   taillePreferee :
                   new Dimension (this.largeur, (int)taillePreferee.getHeight())) ;
    }
    
}
