/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire.igraphique.composants;

import java.util.Observable ;
import java.util.Observer ;

import javax.swing.JCheckBoxMenuItem ;

import fr.histoiremondiale.histoire.utiles.exttypes.Objets;



/**
 * Représente une case à cocher dans un menu.<br>
 * La case est liée à l'état de l'application et modifie son état en fonction de celui de l'appli.<br>
 * La case est cochée si la valeur de l'attribut qu'elle représente est la même que la sienne.<br>
 * La valeur de ce composant est celle fournie au moment de sa création.
 */
public class EltMenuCoche extends JCheckBoxMenuItem implements Observer, ConteneurValeur
{

    private Object objetObserve ;   // Objet contenant l'attribut observé
    private String nomAttribut ;    // Nom de l'attribut que représente l'élément de menu
    private Object valeur ;         // Valeur représentée par cette case à cocher.
    
    
    
    /**
     * Constructeur.
     * @param texte        Texte de l'élément de menu.
     * @param objetObserve Objet observé.
     * @param nomAttribut  Nom de l'attribut observé.
     * @param valeur       Valeur initiale.
     */
    public EltMenuCoche (String texte, Observable objetObserve, String nomAttribut, Object valeur)
    {
        // Inscrire l'objet comme observateur
        objetObserve.addObserver (this) ;
        
        // Mémoriser les paramètres
        this.setText (texte) ;
        this.objetObserve = objetObserve ;
        this.nomAttribut  = nomAttribut ;
        this.valeur       = valeur ;
        
        // Représenter l'élément
        ajusterRepresentation() ;
    }



    /**
     * Réception d'une notification de modification de l'état de l'application.
     */
    public void update (Observable observe, Object param)
    {
        String eltModifie = (String) param ;
        
        // Ajuster la représentation de l'élément de menu s'il est concerné
        if (this.nomAttribut == null || this.nomAttribut.equals (eltModifie))
            ajusterRepresentation() ;
    }
    
    
    /**
     * Coche ou décoche la case en fonction de la valeur de l'attribut qui lui est associé.
     */
    public void ajusterRepresentation ()
    {
        Object valAttribut = Objets.valAttribut (this.objetObserve, this.nomAttribut) ;
        this.setSelected (this.valeur.equals (valAttribut)) ;
    }


    
    // Accesseurs
    public Object objetObserve () { return this.objetObserve ; }
    public String nomAttribut  () { return this.nomAttribut ; }
    public Object valeur       () { return this.valeur ; }

}
