/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire.igraphique.composants;

import java.util.Observable ;
import java.util.Observer ;




//import javax.swing.JSlider ;


import fr.histoiremondiale.histoire.utiles.exttypes.Objets;



/**
 * Glissière avec apparence Metal et dont la valeur de déplacement (incrément) est facile à spécifier.<br>
 *   (note : pas suffisant avec extent)<br>
 * La valeur de ce composant est celle sélectionnée par le curseur.
 */
public class GlissiereDates extends BarreTemps implements Observer, ConteneurValeur
{

    private int    increment ;          // Valeur de laquelle il faut décaler la glissière
    private Object objetObserve ;       // Objet contenant l'attribut observé
    private String nomAttrVal ;         // Nom de l'attribut que représente le texte
    private String nomAttrIncr ;        // Nom de l'attribut contenant le pas de déplacement

    
    
    /**
     * Constructeur.
     * @param objetObserve Objet observé
     * @param nomAttrVal  Nom de l'attribut observé représentant la valeur affichée.
     * @param nomAttrIncr Nom de l'attribut observé représentant la valeur de l'incrément par bloc.
     * @param valMin      Valeur minimale.
     * @param valMax      Valeur maximale.
     * @param valCourante Valeur initiale.
     * @param increment   Valeur initiale de l'incrément.
     */
    public GlissiereDates (Observable objetObserve, String nomAttrVal, String nomAttrIncr,
                           int valMin, int valMax, int valCourante, int increment)
    {
        super (valMin, valMax, valCourante, increment) ;
        
        // Inscrire l'objet comme observateur
        objetObserve.addObserver (this) ;
        
        // Mémoriser les paramètres
        this.increment    = increment ;
        this.objetObserve = objetObserve ;
        this.nomAttrVal   = nomAttrVal ;
        this.nomAttrIncr  = nomAttrIncr ;
    }
    

    // Modifie la valeur d'incrément
    private void modifIncrement (int increment)
    {
        this.increment = increment ;
        this.setPas (increment);
    }
    
    
    /**
     * Réception d'une notification de modification de l'état de l'application.
     */
    public void update (Observable observe, Object param)
    {
        String eltModifie = (String) param ;
        
        // Ajuster la représentation du composant s'il est concerné
        if (this.nomAttrVal.equals (eltModifie) || this.nomAttrIncr.equals (eltModifie))
            ajusterRepresentation() ;
    }

    
    /**
     * Ajuste le composant en fonction de la valeur de l'attribut qui lui est associé.
     */
    public void ajusterRepresentation ()
    {
        // Récupérer la valeur des attributs
        // (valeur représentée par la glissière)
        Object valeur = Objets.valAttribut (this.objetObserve, this.nomAttrVal) ;
        this.setValeur ((Integer) valeur) ;
        // (valeur d'incrément)
        Object increment = Objets.valAttribut (this.objetObserve, this.nomAttrIncr) ;
        modifIncrement ((Integer) increment) ;
    }


    
    // Accesseurs
    public int increment       () { return this.increment ; }
    public Object objetObserve () { return this.objetObserve ; }
    public String nomAttrVal   () { return this.nomAttrVal ; }
    public String nomAttrIncr  () { return this.nomAttrIncr ; }
    public Object valeur       () { return this.getValeur () ; }
    
}
