/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.ecouteurs;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.SwingUtilities;

import fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.Evenement;
import fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.GestEvenementsGenerique;
import fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.Evenement.TypeEvt;



/**
 * Détecte les simples clics droits avec la touche majuscule enfoncée sur un composant donné et en informe
 *   le gestionnaire d'événements.
 */
public class EcouteurClicDroitMajuscule implements MouseListener
{
    
    private Component      composant ;      // Composant écouté
    private GestEvenementsGenerique gestEvts ;       // Gestionnaire d'événements à contacter
    
    
    
    /**
     * Constructeur.
     * @param composant Le composant écouté.
     * @param gestEvenementsGeneriques  Gestionnaire d'événements à contacter.
     */
    public EcouteurClicDroitMajuscule (Component composant, GestEvenementsGenerique gestEvenementsGeneriques)
    {
        this.composant = composant ;
        this.gestEvts  = gestEvenementsGeneriques ;
    }

    
    
    // Interception de l'événement
    public void mouseClicked (MouseEvent evt)
    {
        if (SwingUtilities.isRightMouseButton(evt) && (evt.getClickCount() == 1) && (evt.isShiftDown()))
            this.gestEvts.traiterEvenement (new Evenement (this.composant, TypeEvt.CLIC_DROIT_MAJUSCULE, evt)) ;
    }

    
    
    // Méthodes inutilisées
    public void mouseEntered  (MouseEvent evt) {}
    public void mouseExited   (MouseEvent evt) {}
    public void mousePressed  (MouseEvent evt) {}
    public void mouseReleased (MouseEvent evt) {}
}
