/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire.utiles.math;





/**
 * Représente une matrice.
 */
public class Matrice
{

    private double[][] valeurs ;        // Valeurs contenues dans la matrice
    
    
    
    /**
     * Construit une matrice vide de taille donnée.<br>
     * La matrice créée est pleine de zéros.
     * @param nbLignes   Nombre de lignes.
     * @param nbColonnes Nombre de colonnes.
     */
    public Matrice (int nbLignes, int nbColonnes)
    {
        this.valeurs = new double[nbLignes][nbColonnes] ;
    }
    
    
    /**
     * Crée une matrice dont le contenu est fourni en paramètre.
     * La première dimension représente les lignes.<br>
     * Les dimensions de la matrice sont déduites de celle du tableau.
     * @param valeurs Le tableau dont le contenu servira à créer et initialiser la matrice.
     */
    public Matrice (double[][] valeurs)
    {
        this.valeurs = valeurs ;
    }
    
    
    
    /**
     * Renvoie le nombre de lignes de la matrice.
     * @return Le nombre de lignes de la matrice.
     */
    public int nbLignes ()
    {
        return this.valeurs.length ;
    }
    
    /**
     * Renvoie le nombre de colonnes de la matrice.
     * @return Le nombre de colonnes de la matrice.
     */
    public int nbColonnes ()
    {
        return this.valeurs[0].length ;
    }
    
    
    /**
     * Renvoie la valeur à la position donnée.<br>
     * Les indices commencent à 1.
     * @param numLigne   Indice de la ligne.
     * @param numColonne Indice de la colonnes.
     * @return La valeur à cette position.
     */
    public double val (int numLigne, int numColonne)
    {
        return this.valeurs[numLigne-1][numColonne-1] ;
    }
    

    /**
     * Modifie la valeur à la position donnée.<br>
     * Les indices commencent à 1.
     * @param numLigne   Indice de la ligne.
     * @param numColonne Indice de la colonnes.
     * @param valeur     La nouvelle valeur.
     */
    public void modVal (int numLigne, int numColonne, double valeur)
    {
        this.valeurs[numLigne-1][numColonne-1] = valeur ;
    }
    
    
    /**
     * Renvoie la matrice transformée de la matrice courante.<br>
     * Transposée ?<br>
     * dans le cas présent la transformation est équivalente car Inverse de A=Transposée de A.
     * @return la matrice transformée.
     */
    public Matrice transformation ()
    {
        Matrice matriceTransformee ;    // Matrice à calculer
        
        
        // Remplir la nouvelle matrice
        matriceTransformee = new Matrice (this.nbColonnes(), this.nbLignes()) ;
        for (int iLig = 1 ; iLig <= this.nbLignes()   ; iLig++)
        for (int iCol = 1 ; iCol <= this.nbColonnes() ; iCol++)
        {
            matriceTransformee.modVal (iCol, iLig, this.val (iLig, iCol)) ;
        }
        
        // Renvoyer la matrice résultat
        return matriceTransformee ;
    }
    
    
    // Renvoie la représentation de la matrice sous forme de chaîne
    public String toString ()
    {
        String chRes = "" ;
        
        
        // Créer la représentation
        chRes += "{" ;
        for (int iLig = 1 ; iLig <= this.nbLignes()   ; iLig++)
        {
            chRes += "{" ;
            for (int iCol = 1 ; iCol <= this.nbColonnes() ; iCol++)
            {
                if (iCol > 1)
                    chRes += ",\t" ;
                chRes += this.val (iLig, iCol) ;
            }
            chRes += "}" ;
            if (iLig < this.nbLignes())
                chRes += "\n " ;
        }
        chRes += "}" ;
        
        // Renvoyer le résultat
        return chRes ;
    }
    
}
