/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire.utiles.math;





/**
 * Représente un point dans l'espace (en 3 dimensions).
 */
public class PointEspace
{

    private double x ;          // Coordonnées du point
    private double y ;
    private double z ;
    
    
    
    /**
     * Constructeur.
     * @param x Coordonnées x du point.
     * @param y Coordonnées y du point.
     * @param z Coordonnées z du point.
     */
    public PointEspace (double x, double y, double z)
    {
        this.x = x ;
        this.y = y ;
        this.z = z ;
    }
    
    
    // Représentation sous forme de chaîne
    public String toString ()
    {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")" ;
    }
    
    
    /**
     * Renvoie la distance au carré entre le point courant et le point en paramètre.
     * @param p2 Le deuxième point.
     * @return La distance au carré entre deux points.
     */
    public double distanceCarreeA (PointEspace p2)
    {
        double x1 = this.x () ;
        double y1 = this.y () ;
        double z1 = this.z () ;
        double x2 = p2.x () ;
        double y2 = p2.y () ;
        double z2 = p2.z () ;
        return (x2-x1)*(x2-x1) + (y2-y1)*(y2-y1) + (z2-z1)*(z2-z1) ;
    }
    
    
    // Accesseurs
    public double x ()
    {
        return this.x ;
    }
    public double y ()
    {
        return this.y ;
    }
    public double z ()
    {
        return this.z ;
    }
    
}
