/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */

package fr.histoiremondiale.histoire ;

import java.io.File ;
import java.io.FileOutputStream ;
import java.io.OutputStreamWriter ;
import java.io.PrintWriter ;
import java.text.DecimalFormat ;

import fr.histoiremondiale.histoire.utiles.es.fichiers.Fichiers ;



public class ConcatenationParagraphes
{

    public static void main (String[] args) throws Exception
    {
        // Attention, l'ordre de test compte un peu (initialisation de classes java et autres sans doute)
        chargerParagraphesFichierUnique() ;
        chargerParagraphesFichiersMultiples () ;
//        concatenerParagraphes() ;
    }
    
    
    public static void concatenerParagraphes () throws Exception
    {
        PrintWriter ecrFic = new PrintWriter (new OutputStreamWriter (new FileOutputStream ("donnees/histoire/paragraphes/paragraphes.txt"), "UTF-8")) ;
        
        for (int i = 0 ; i < 400 ; i++)
        {
            String chemFicParagraphe = "donnees/histoire/paragraphes/paragraphe" + new DecimalFormat("0000").format (i) + ".txt" ;
            File   ficParagraphe     = new File (chemFicParagraphe) ;
            if (ficParagraphe.exists())
            {
                String texteParagraphe = Fichiers.chargerContenuTexte (chemFicParagraphe, "UTF-8") ;
                ecrFic.println (""+i) ;
                ecrFic.println (texteParagraphe) ;
                ecrFic.println ("--------------------------------------------------------------") ;
            }
        }
        
        ecrFic.close() ;
    }
    
    
    public static void chargerParagraphesFichiersMultiples () throws Exception
    {
        long debut = System.currentTimeMillis() ;
        for (int i = 0 ; i < 313 ; i++)
        {
            String chemFicParagraphe = "donnees/histoire/paragraphes/paragraphe" + new DecimalFormat("0000").format (i) + ".txt" ;
            File   ficParagraphe     = new File (chemFicParagraphe) ;
            if (ficParagraphe.exists())
            {
                Fichiers.chargerContenuTexte (chemFicParagraphe, "UTF-8") ;
            }
        }
        long fin = System.currentTimeMillis() ;
        System.out.println ("Chargement des paragraphes depuis les fichiers multiples : " + (fin - debut)) ;
    }
    
    
    public static void chargerParagraphesFichierUnique () throws Exception
    {
        long debut = System.currentTimeMillis() ;
        Fichiers.chargerContenuTexte ("donnees/histoire/paragraphes/paragraphes.txt", "UTF-8") ;
        long fin = System.currentTimeMillis() ;
        System.out.println ("Chargement des paragraphes depuis un seul fichier : " + (fin - debut)) ;
    }
    
}
