/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire.igraphique.tracercartes;

import java.awt.Color ;

import fr.histoiremondiale.histoire.utiles.math.PointSphere;

//import fr.histoiremondiale.histoire.utiles.math.PointSphere;





/**
 * Demande de tracer de carte. La demande ne contient que des données simples, qui permettront d'aller
 *   chercher les données nécessaires au tracer. Une demande doit en effet pouvoir être créée le plus
 *   rapidement possible.<br>
 */
public class DemandeTracerCarte
{
    
    public int         annee ;
    public boolean     fleuvesAffiches ;
    public boolean     meridiensParallelesAffiches ;
    public PointSphere ptCentrePlan ;
    public int         largeurCarte ;       // Taille de la carte elle-même
    public int         hauteurCarte ;
    public double      loupe ;
    public Color       coulMers ;
    public Color       coulTerres ;
    public Color       coulFleuves ;
    
    
    /**
     * Constructeur.
     * @param annee                       Année choisie pour la carte.
     * @param fleuvesAffiches             Indique si les fleuves doivent être affichés.
     * @param meridiensParallelesAffiches Indique si les méridiens et parallèles doivent être affichés.
     * @param ptCentrePlan                Point à projeter au centre de la carte.
     * @param largeurCarte                Largeur de la carte.
     * @param hauteurCarte                Hauteur de la carte.
     * @param loupe                       Valeur de grossissement de la loupe.
     * @param coulMers                    Couleur des mers.
     * @param coulTerres                  Couleur des terres.
     * @param coulFleuves                 Couleur des fleuves.
     */
    public DemandeTracerCarte (int annee,
                               boolean fleuvesAffiches, boolean meridiensParallelesAffiches,
                               PointSphere ptCentrePlan, 
                               int largeurCarte, int hauteurCarte,
                               double loupe,
                               Color coulMers, Color coulTerres, Color coulFleuves)
    {
        this.annee                       = annee ;
        this.fleuvesAffiches             = fleuvesAffiches ;
        this.meridiensParallelesAffiches = meridiensParallelesAffiches;
        this.ptCentrePlan                = ptCentrePlan ;
        this.largeurCarte                = largeurCarte ;
        this.hauteurCarte                = hauteurCarte ;
        this.loupe                       = loupe ;
        this.coulMers                    = coulMers ;
        this.coulTerres                  = coulTerres ;
        this.coulFleuves                 = coulFleuves ;
    }
    
    // Comparaison de deux demandes (égalité)
    public boolean equals (Object o)
    {
        if (o == null)
            return false ;
        if (this == o)
            return true ;
        if (! (o.getClass() == this.getClass()))
            return false ;
        
        DemandeTracerCarte d1 = this ;
        DemandeTracerCarte d2 = (DemandeTracerCarte) o ;
        // (en commençant par les plus discriminant et les plus faciles à tester)
        return d1.annee                       == d2.annee &&
               d1.fleuvesAffiches             == d2.fleuvesAffiches &&
               d1.meridiensParallelesAffiches == d2.meridiensParallelesAffiches &&
               d1.largeurCarte                == d2.largeurCarte &&
               d1.hauteurCarte                == d2.hauteurCarte &&
               d1.loupe                       == d2.loupe &&
               d1.ptCentrePlan.equals     (d2.ptCentrePlan) &&
               d1.coulMers.equals         (d2.coulMers) &&
               d1.coulTerres.equals       (d2.coulTerres) &&
               d1.coulFleuves.equals      (d2.coulFleuves) ;
    }
    
}
