/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire.utiles.exceptions;



/**
 * Fonctions utilitaires sur les exceptions.
 */
public class Exceptions
{

    /**
     * Crée un message composé des message d'erreur de l'exception et de ses causes.
     * @param exception Exception pour laquelle construire un message.
     * @return Une chaîne contenant le message d'erreur agrégé.
     */
    public static String extraireMessagesErreur (Throwable exception)
    {
        StringBuilder msg = new StringBuilder (exception.getMessage() + "\n") ;
        
        // Rassembler les messages des causes
        Throwable exceptionCourante = exception.getCause() ;
        while (exceptionCourante != null)
        {
            msg.append ("(cause : ")
               .append (exceptionCourante.getMessage())
               .append (")\n") ;
            exceptionCourante = exceptionCourante.getCause() ;
        }
        
        // Renvoyer le message agrégé
        return msg.toString() ;
    }
    
}
