/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire.utiles.igraphique.dessin.hachures;

import java.awt.Color ;
import java.awt.Paint ;
import java.awt.PaintContext ;
import java.awt.Rectangle ;
import java.awt.RenderingHints ;
import java.awt.Transparency ;
import java.awt.geom.AffineTransform ;
import java.awt.geom.Rectangle2D ;
import java.awt.image.ColorModel ;



/**
 * Outil permettant de peindre des hachures.
 */
public class PeintureHachures implements Paint
{

    private ContextePeintureHachures contextePeinture ;         // Contexte de peinture des hachures (couleurs, ...)


    
    /**
     * Constructeur.
     * @param couleur     La couleur des hachures.
     * @param espace      L'espace entre les hachures.
     * @param angle       L'angle des hachures.
     * @param epaisseur   L'épaisseur des hachures.
     * @param largeurFlou Largeur du flou autour des hachures (?).
     */
    public PeintureHachures (Color couleur, double espace, double angle, double epaisseur, int largeurFlou)
    {
        this.contextePeinture = new ContextePeintureHachures (couleur, espace, angle, epaisseur, largeurFlou) ;
    }
    

    /**
     * Transparence activée.
     */
    public int getTransparency()
    {
        return Transparency.TRANSLUCENT ;
    }

    
    
    // Renvoie le contexte associé à ce type de peinture
    public PaintContext createContext (ColorModel modeleCouleurs, Rectangle limitesComposant,
                                       Rectangle2D limitesUtilisateur, AffineTransform transformation,
                                       RenderingHints criteresRendu)
    {
        return this.contextePeinture ;
    }
    
    
    /**
     * Modifie la couleur des hachures.
     * @param nouvCouleur Nouvelle couleur.
     */
    public void modifCoulHachures (Color nouvCouleur)
    {
        this.contextePeinture.modifCoulHachures (nouvCouleur) ;
    }
    
}
