/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire.utiles.igraphique.swing;

import java.awt.Dialog ;
import java.awt.Dimension ;
import java.awt.Frame ;
import java.awt.Toolkit ;
import java.awt.event.ActionEvent ;
import java.awt.event.ActionListener ;
import java.awt.event.KeyEvent ;

import javax.swing.JComponent ;
import javax.swing.JDialog ;
import javax.swing.JFrame ;
import javax.swing.KeyStroke ;



/**
 * Méthodes utiles pour la gestion des fenêtres.
 */
public class Fenetres
{

    /**
     * Centre la fenêtre sur l'écran.
     * @param fenetre Fenêtre à positionner.
     */
    public static void centrer (Frame fenetre)
    {
        Dimension tailleEcran = Toolkit.getDefaultToolkit().getScreenSize() ;
        int xFen = (int) (tailleEcran.getWidth()  - fenetre.getWidth())  / 2 ;
        int yFen = (int) (tailleEcran.getHeight() - fenetre.getHeight()) / 2 ;
        fenetre.setLocation (xFen, yFen) ;
    }
    

	public static void centrer(JFrame enfant, JFrame parent) 
	{
		if (parent == null) centrer(enfant);
		else centrer(enfant, parent.getX() + parent.getWidth() / 2,
						parent.getY() + parent.getHeight() / 2);
		
	}
    
    private static void centrer(JFrame enfant, int xCentre, int yCentre) 
    {
        enfant.setLocation (xCentre - enfant.getWidth()  / 2,
                yCentre - enfant.getHeight() / 2) ;
	}


	/**
     * Centre la boîte de dialogue sur une fenêtre.
     * Si la fenêtre parent vaut null, centre la boîte de dialogue sur l'écran.
     * @param dialogue    La boîte de dialogue à positionner.
     * @param fenetreMere La fenêtre dont la position sert de référence.
     */
    public static void centrer (Dialog dialogue, Frame fenetreMere)
    {
        if (fenetreMere == null)
        {
            Dimension tailleEcran = Toolkit.getDefaultToolkit().getScreenSize() ;
            centrer (dialogue, (int) tailleEcran.getWidth() / 2, (int) tailleEcran.getHeight() / 2) ;
        }
        else
        {
            centrer (dialogue, fenetreMere.getX() + fenetreMere.getWidth()  / 2,
                               fenetreMere.getY() + fenetreMere.getHeight() / 2) ;
        }
    }
    
    /**
     * Centre la boîte de dialogue sur un point dont on donne les coordonnées.
     * @param dialogue La boîte de dialogue à positionner.
     * @param xCentre  Abscisse du point sur lequel centrer la boîte.
     * @param yCentre  Ordonnée du point sur lequel centrer la boîte.
     */
    public static void centrer (Dialog dialogue, int xCentre, int yCentre)
    {
        dialogue.setLocation (xCentre - dialogue.getWidth()  / 2,
                              yCentre - dialogue.getHeight() / 2) ;
    }
    
    
    /**
     * Ajoute un écouteur qui masque la boîte de dialogue en paramètre quand on presse la touche Echap.
     * @param dialogue Boîte de dialogue à traiter.
     */
    public static void ajouterEcouteurEchapPourMasquer (final JDialog dialogue)
    {
        dialogue.getRootPane().registerKeyboardAction
                (new ActionListener() { public void actionPerformed (ActionEvent evt) { dialogue.setVisible(false) ; } },
                 KeyStroke.getKeyStroke (KeyEvent.VK_ESCAPE, 0), 
                 JComponent.WHEN_IN_FOCUSED_WINDOW) ; 
    }
    
    /**
     * Ajoute un écouteur qui masque la fenêtre en paramètre quand on presse la touche Echap.
     * @param fenetre fenêtre à traiter.
     */
    public static void ajouterEcouteurEchapPourMasquer (final JFrame fenetre)
    {
        fenetre.getRootPane().registerKeyboardAction
                (new ActionListener() { public void actionPerformed (ActionEvent evt) { fenetre.setVisible(false) ; } },
                 KeyStroke.getKeyStroke (KeyEvent.VK_ESCAPE, 0), 
                 JComponent.WHEN_IN_FOCUSED_WINDOW) ; 
    }

    /**
     * Ajoute un écouteur qui masque la boîte de dialogue en paramètre quand on presse la touche Entrée.
     * @param dialogue Boîte de dialogue à traiter.
     */
    public static void ajouterEcouteurEntreePourMasquer (final JDialog dialogue)
    {
        dialogue.getRootPane().registerKeyboardAction
                (new ActionListener() { public void actionPerformed (ActionEvent evt) { dialogue.setVisible(false) ; } },
                 KeyStroke.getKeyStroke (KeyEvent.VK_ENTER, 0), 
                 JComponent.WHEN_IN_FOCUSED_WINDOW) ; 
    }



    
}
