/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements;

import java.awt.Component ;
import java.util.EventObject ;



/**
 * Représente un événement du système de gestion des événements.
 */
public class Evenement
{

    // Constantes
    // (types d'événements existants)
    public static enum TypeEvt {// Souris
                                CLIC_GAUCHE,                // Clic gauche sur un composant
                                CLIC_DROIT,                 // Clic droit  sur un composant
                                CLIC_DROIT_MAJUSCULE,       // Clic droit avec shift
                                CLIC_GAUCHE_ELT_MENU,       // Clic gauche sur un élement de menu (l'élément concerné est le menu, l'élément de menu peut être retrouvé dans l'événement AWT)
                                PRESSION_GAUCHE,            // Pression bouton gauche de la souris 
                                PRESSION_DROIT,             // Pression bouton droit  de la souris
                                MOLETTE_SOURIS,             // Déplacement de la molette de la souris
                                GLISSEMENT_SOURIS,          // Glissement souris avec appui sur bouton
                                MOUVEMENT_SOURIS,           // Mouvement de la souris au-dessus d'un composant
                                SORTIE_SOURIS,              // Sortie de la souris du composant
                                // Fenêtre
                                FERMETURE_FENETRE,          // Juste avant que la fenêtre se ferme
                                // Autres composant
                                CHANGEMENT_VALEUR,          // Changement de valeur d'un composant
                                CHANGEMENT_ETAT,            // Changement d'état d'un composant
                                REDIMENSIONNEMENT,          // Redimensionnement du composant
                               } ;

                               
    // Données
    private Component   composant ;     // Composant sur lequel l'événement s'est produit (Component est une classe mère de JComponent et JFrame par exemple)
    private TypeEvt     typeEvt ;       // Type de l'événement
    private EventObject evtComplet ;    // Evénement réel (pour l'accès aux détails de ce qui s'est passé)
    
    
    
    /**
     * Constructeur.
     * @param composant  Composant source de l'événement.
     * @param typeEvt    Type de l'événement.
     * @param evtComplet Objet représentant l'événement Java.
     */
    public Evenement (Component composant, TypeEvt typeEvt, EventObject evtComplet)
    {
        this.composant  = composant ;
        this.typeEvt    = typeEvt ;
        this.evtComplet = evtComplet ;
    }

    
    
    // Accesseurs
    public Component   composant  () { return this.composant ; }
    public TypeEvt     typeEvt    () { return this.typeEvt ; }
    public EventObject evtComplet () { return this.evtComplet ; }
    
}
