/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.ecouteurs;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;

import fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.Evenement;
import fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.GestEvenementsGenerique;
import fr.histoiremondiale.histoire.utiles.igraphique.swing.evenements.Evenement.TypeEvt;



/**
 * Capture les simples clics gauche sur un élément de menu donné et en informe le gestionnaire d'événements.
 * Note : Apparemment ça ne fonctionne pas avec MouseListener : l'écouteur ne reçoit pas les événements
 *        alors que ça fonctionne avec ActionListener.
 */
public class EcouteurClicGaucheEltMenu implements ActionListener
{

    private JComponent     menu ;           // Menu contenant l'élément écouté
    private GestEvenementsGenerique gestEvts ;       // Gestionnaire d'événements à contacter
    
    
    
    /**
     * Constructeur.
     * @param menu2     Le composant écouté.
     * @param gestEvenementsGeneriques Gestionnaire d'événements à contacter.
     */
    public EcouteurClicGaucheEltMenu (JMenu menu2, GestEvenementsGenerique gestEvenementsGeneriques)
    {
        this.menu     = menu2 ;
        this.gestEvts = gestEvenementsGeneriques ;
    }
    
    
    /**
     * Constructeur.
     * @param menu     Le menu écouté.
     * @param gestEvts Gestionnaire d'événements à contacter.
     */
    public EcouteurClicGaucheEltMenu (JPopupMenu menu, GestEvenementsGenerique gestEvts)
    {
        this.menu     = menu ;
        this.gestEvts = gestEvts ;
    }

    
    
    // Interception de l'événement
    public void actionPerformed (ActionEvent evt)
    {
        this.gestEvts.traiterEvenement (new Evenement (this.menu, TypeEvt.CLIC_GAUCHE_ELT_MENU, evt)) ;
    }
    
}
