/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire.donnees;



/**
 * Représente le centre d'une civilisation pendant une période donnée.
 */
public class CentreCivilisation
{

    private double longitude ;
    private double latitude ;
    private int    debut ;            // Début/fin de la période
    private int    fin ;
    
    
    
    /**
     * Constructeur avec les attributs simples.
     * @param longitude La longitude du centre.
     * @param latitude  La latitude du centre.
     * @param debut     Le début de la période.
     * @param fin       La fin de la période.
     */
    public CentreCivilisation (double longitude, double latitude, int debut, int fin)
    {
        this.longitude    = longitude ;
        this.latitude     = latitude ;
        this.debut        = debut ;
        this.fin          = fin ;
    }

    
    
    // Autres accesseurs
    public double       longitude    () { return this.longitude ; } ;
    public double       latitude     () { return this.latitude ; } ;
    public int          debut        () { return this.debut ; } ;
    public int          fin          () { return this.fin ; } ;

}
