/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire.igraphique.composants;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.BorderFactory;
import javax.swing.JDialog ;
import javax.swing.JEditorPane;
import javax.swing.JFrame;

import fr.histoiremondiale.histoire.utiles.igraphique.swing.Fenetres;



public class DialogBiblio extends JDialog
{
    
	String texte;
	
	
	public DialogBiblio(String biblio, JFrame parent) 
	{
		super((JFrame)null,"Bibliographie", true );
		texte = biblio;
		addWindowListener(new WindowAdapter() 
		{
			@Override
			public void windowClosing(WindowEvent e)
			{
				dispose();
			}
		});
		initComponent();
		pack();
		Fenetres.centrer(this, parent);
		Fenetres.ajouterEcouteurEchapPourMasquer(this);
	}
	
	private void initComponent() 
	{
		JEditorPane page = new JEditorPane("text/html",texte);
		page.setEditable(false);
		page.setBorder(BorderFactory.createLineBorder(Color.BLUE, 2, true));
		page.setPreferredSize(new Dimension(1200,500));
		add(page, BorderLayout.NORTH);
	}
	
	public void showDialogBiblio() 
	{
		setVisible(true);
		dispose();
	}
	
}
