/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire.igraphique.tracercartes;

import java.awt.Polygon ;
import java.awt.Rectangle ;
import java.awt.image.BufferedImage ;
import java.util.HashMap ;
import java.util.List ;
import java.util.Map ;

import fr.histoiremondiale.histoire.utiles.math.PointPlan;
import fr.histoiremondiale.histoire.utiles.math.PointSphere;
import fr.histoiremondiale.histoire.donnees.Territoire;
//import fr.histoiremondiale.histoire.utiles.math.PointPlan;
//import fr.histoiremondiale.histoire.utiles.math.PointSphere;



/**
 * Informations sur une image tracée ou dont le tracer est en cours.
 */
public class InfosImage
{
    
    public DemandeTracerCarte         demande ;                         // Demande à l'origine de cette image
    public BufferedImage              image ;                           // Image créée à partir de la demande.
    
    public Map<PointSphere,PointPlan> cachePoints ;                     // Points en cache (déjà projetés)
    public Map<Integer,List<Polygon>> multiPolygonesPourtoursTraces ;   // (version 2 du tracé : le territoire est constitué de plusieurs zones)
    public Map<Integer,Territoire>    territoiresTraces ;               // Territoires tracés sur l'image
    public Map<Rectangle,Territoire>  textesTerritoiresTraces ;         // Textes des territoires tracés sur l'image
    public BufferedImage              imgCompleteSansTextes ;           // Image sans les textes
    
    public boolean                    perimee ;                         // Indique que l'image n'est plus d'actualité (une autre est en cours de tracé)
    public Throwable                  erreur ;                          // Si une erreur est survenue pendant le tracer de la carte

    
    
    /**
     * Constructeur.
     */
    public InfosImage ()
    {
        this.cachePoints                   = new HashMap<>() ;
        this.multiPolygonesPourtoursTraces = new HashMap<>() ;
        this.territoiresTraces             = new HashMap<>() ;
        this.textesTerritoiresTraces       = new HashMap<>() ;
    }

}
