/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire.utiles.math;


import java.awt.Point;



/**
 * Représente un point dans un plan.
 */
public class PointPlan 
{

    private double x ;          // Coordonnées du point
    private double y ;
    
    
    
    /**
     * Constructeur simple à partir des coordonnées (x, y) du point.
     * @param x Coordonnée x du point.
     * @param y Coordonnée y du point.
     */
    public PointPlan (double x, double y)
    {
        this.x = x ;
        this.y = y ;
    }
    
    public PointPlan(Point P)
    {
    	this(P.getX(), P.getY());
    }
    
    
    /**
     * Indique si deux points sont confondus, en arrondissant les coordonnées à des nombres entiers
     *   (par transtypage avec (int)).
     * @param p2 Deuxième point.
     * @return Vrai si les deux point sont confondus en coordonnées entières, faux sinon.
     */
    public boolean confonduCoordEntieres (PointPlan p2)
    {
        int x1 = (int) this.x() ;
        int y1 = (int) this.y() ;
        int x2 = (int) p2.x() ;
        int y2 = (int) p2.y() ;
        return x1 == x2 && y1 == y2 ;
    }
    
    
    
    // Représentation sous forme de chaîne
    public String toString ()
    {
        return "(" + this.x + ", " + this.y + ")" ;
    }
    
    
    /**
     * Renvoie la distance entre le point courant et le point en paramètre.
     * @param p2 Deuxième point.
     * @return La distance entre les deux points.
     */
    public double distanceA (PointPlan p2)
    {
        double dx = p2.x - this.x ;
        double dy = p2.y - this.y ;
        return Math.sqrt (dx*dx + dy*dy) ;
    }
    
    
    // Accesseurs
    public double x ()
    {
        return this.x ;
    }
    public double y ()
    {
        return this.y ;
    }
    
}
