/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire.utiles.visualisation;

import java.awt.Color ;
import java.awt.Dimension ;
import java.awt.Graphics ;
import java.awt.GridLayout ;
import java.awt.Toolkit ;
import java.util.List ;

import javax.swing.JFrame ;
import javax.swing.JPanel ;

import fr.histoiremondiale.histoire.HistoireMondiale;
import fr.histoiremondiale.histoire.donnees.Fleuve;
import fr.histoiremondiale.histoire.donnees.Mer;
import fr.histoiremondiale.histoire.donnees.Terre;
import fr.histoiremondiale.histoire.donnees.Territoire;
import fr.histoiremondiale.histoire.igraphique.PanCarte;
import fr.histoiremondiale.histoire.igraphique.tracercartes.InfosTracerImage;
import fr.histoiremondiale.histoire.igraphique.tracercartes.TraceurCarte;
import fr.histoiremondiale.histoire.utiles.math.PointSphere;



/**
 * Fenêtre permettant d'afficher simplement une carte correspondant aux informations demandées.
 */
public class FenAffCarte extends JFrame
{

    private static final int     ANNEE                         = -280 ;
    private static final boolean FLEUVES_AFFICHES              = true ;
    private static final boolean MERIDIENS_PARALLELES_AFFICHES = true ;
    private static final double  LATITUDE_CENTRE               = 55.0 ;
    private static final double  LONGITUDE_CENTRE              = 179.0 ;
    private static final int     LARGEUR_CARTE                 = 564 ;
    private static final int     HAUTEUR_CARTE                 = 561 ;
    private static final double  LOUPE                         = 1.0 ;
    private static final Color   COULEUR_MERS                  = PanCarte.COUL_MERS ;
    private static final Color   COULEUR_TERRES                = PanCarte.COUL_TERRES ;
    private static final Color   COULEUR_FLEUVES               = PanCarte.COUL_FLEUVES ;

    
    
    /**
     * Constructeur.
     */
    public FenAffCarte ()
    {
        super ("Affichage d'une carte") ;
        
        // Placer les composant sur la fenêtre
        this.setLayout (new GridLayout (1, 1)) ;
        JPanel p_carte = new JPanel ()
        {
            public void paintComponent (Graphics g)
            {
                List<Terre>      terres             = HistoireMondiale.instance().carte().terres() ;
                List<Mer>        mersInterieures    = HistoireMondiale.instance().carte().mers() ;
                List<Fleuve>     fleuves            = HistoireMondiale.instance().carte().fleuves() ;
                List<Territoire> territoiresATracer = HistoireMondiale.instance().donneesHisto().territoiresAnnee (ANNEE) ;
                new TraceurCarte().tracerCarte (terres, mersInterieures, fleuves, territoiresATracer,
                                                ANNEE, FLEUVES_AFFICHES, MERIDIENS_PARALLELES_AFFICHES,
                                                new PointSphere (LONGITUDE_CENTRE, LATITUDE_CENTRE),
                                                LARGEUR_CARTE, HAUTEUR_CARTE, LOUPE,
                                                COULEUR_MERS, COULEUR_TERRES, COULEUR_FLEUVES,
                                                g,
                                                new InfosTracerImage())   ;
            }
        } ;
        this.getContentPane().add (p_carte) ;
        
        this.setDefaultCloseOperation (JFrame.EXIT_ON_CLOSE) ;

        // Afficher la fenêtre
        int largeurFenetre = LARGEUR_CARTE + 50 ;
        int hauteurFenetre = HAUTEUR_CARTE + 50 ;
        Dimension tailleEcran = Toolkit.getDefaultToolkit().getScreenSize() ;
        // (placer la fenêtre)
        this.setSize (largeurFenetre, hauteurFenetre) ;
        // (centrer la fenêtre)
        int xFen = (int) (tailleEcran.getWidth()  - largeurFenetre) / 2 ;
        int yFen = (int) (tailleEcran.getHeight() - hauteurFenetre) / 2 ;
        this.setLocation (xFen, yFen) ;
    }
    
        
    // Méthode principale
    public static void main (String[] args)
    {
        FenAffCarte fenetre = new FenAffCarte() ;
        fenetre.setVisible (true) ;
    }
    
}
