@echo off
chcp 65001>nul

REM Automatiser la transformation des fichiers java du projet Histoire Mondiale (https://sourceforge.net/projects/histmondiale/) en un exécutable windows et son installeur
REM A T T E N T I O N ! 
REM Il faut indiquer en paramètre le répertoire contenant les classe java (*.java) du projet
REM Cela est spécifique à chaque utilisateur, en particulier où vous avez téléchargé vos fichiers java
REM Dans mon cas j'utilise les classes se trouvant dans le projet eclipse F:\Mes projets java\histmondiale-code-git\src
REM donc creerexe sans paramètre est équivallent à creerexe "F:\Mes projets java\histmondiale-code-git"
REM Par ailleurs il faut avoir installer Launch4J (http://launch4j.sourceforge.net/) qui peut transformer un jar en exécutable windows (.exe)
REM Il faut aussi installer Inno Setup (https://jrsoftware.org/isdl.php) qui crée un installeur windows à partir d'un exécutable
REM et bien entendu il faut avoir installer Java (https://www.java.com/fr/download/)

REM programme sans paramètre
if %1a==a GOTO :sans_parametre
REM appel de creerexe avec paramètre : il faut tester le parametre
set SOURCE=%1\
GOTO :test_repertoire

:sans_parametre
set SOURCE="F:\Mes projets java\histmondiale-code-git\"
REM même sans paramètre, il est préférable de vérifier le répertoire SOURCE

:test_repertoire
echo test du territoire %SOURCE%
dir %SOURCE%*.* /S 1>nul 2>nul
if %ERRORLEVEL%==1 GOTO :erreur_repertoire
REM le paramètre est un répertoire
if exist %SOURCE%src\fr\histoiremondiale\histoire\HistoireMondiale.java goto :preparation
REM le paramètre ne contient pas HistoireMondiale.java
echo %SOURCE% ne contient pas src\fr\histoiremondiale\histoire\HistoireMondiale.java
echo pour utiliser creerexe il faut que le paramètre soit un répertoire où trouver le projet Histoire Mondiale
echo exemple creerexe "F:\Mes projets java\histmondiale-code-git"
goto :fin

:erreur_repertoire
echo %SOURCE% n'est pas un répertoire
echo pour utiliser creerexe il faut que le paramètre soit un répertoire où trouver le projet Histoire Mondiale
echo exemple creerexe "F:\Mes projets java\histmondiale-code-git"
goto :fin

:preparation
echo nettoyage du répertoire temporaire
REM %SOURCE% est un répertoire qui contient src\fr\histoiremondiale\histoire\HistoireMondiale.java
REM création du répertoire bin (s'il existe déjà, rien ne se passe)
mkdir tmp\bin 2>nul
REM nettoyage du répertoire temporaire
del tmp\*.* /S /Q 1>nul

REM copie des fichiers java vers le répertoire temporaire
echo copie des fichiers java
xcopy %SOURCE%src\fr tmp\src\fr /E /I 1>nul

REM copie des données
echo copie des donnees
xcopy %SOURCE%donnees\histoire tmp\donnees\histoire /E /I 1>nul

REM copie des icones
echo copie des icones
xcopy %SOURCE%icones\histoire tmp\icones\histoire /E /I 1>nul
xcopy %SOURCE%icones\licences tmp\icones\licences /E /I 1>nul

REM copie des licences
echo copie des licences
xcopy %SOURCE%licence tmp\licence /E /I 1>nul

REM copie des bibliothèques
echo copie des bibliothèques
xcopy %SOURCE%bib tmp\bib  /E /I 1>nul

REM copie de MANIFEST.MF
echo copie du Manifest
xcopy %SOURCE%distribution\execution\MANIFEST.MF tmp\meta-inf /Q /I /Y

REM copie des notes de version
echo copie des notes de version
xcopy %SOURCE%"%%notes de version.txt" tmp /Q /I /Y

REM copie des fichiers nécessaire à Launch4J
echo copie de ce qui est nécessaire à Launch4j
mkdir launch4j 2>nul
del launch4j\*.* /S /Q 1>nul
xcopy %SOURCE%distribution\creation-paquets\windows\launch4j .\launch4j /E /I 1>nul

REM copie des fichiers nécessaires à Inno Setup
echo copie de ce qui est nécessaire à innosetup
mkdir innosetup 2>nul
del innosetup\*.* /S /Q 1>nul
xcopy %SOURCE%distribution\creation-paquets\windows\innosetup .\innosetup /E /I 1>nul
REM copie des ressources
xcopy tmp\bib innosetup\ressources\bib\ /E /I 1>nul
xcopy tmp\donnees innosetup\ressources\donnees\ /E /I 1>nul
xcopy tmp\icones innosetup\ressources\icones\ /E /I 1>nul
xcopy tmp\licence innosetup\ressources\licence\ /E /I 1>nul

PAUSE

:compilation
echo compilation du projet
REM création des classes (il faut être dans le répertoire temporaire car sinon javac ne trouve pas les classes java : il les cherche dans src\fr... au lieu de tmp\src\fr...)
cd tmp
javac src/fr/histoiremondiale/histoire/HistoireMondiale.java -d bin -sourcepath src -encoding utf-8 -cp bib\commons-lang-2.4.jar;bib\h2-1.4.199.jar
cd ..

REM création du jar, (rajouter un v pour avoir plus d'infos sur la génération, par exemple en cas de problème)
REM le jar est créé dans le répertoire temporaire pour pouvoir immédiatement le tester (les données utilisées sont dans ce répertoire temporaire).
REM le point à la fin n'est pas une erreur mais est nécessaire même si je n'ai pas vraiment compris son rôle (à priori il s'agit du répertoire courant)
echo creation du jar (histoiremondiale.jar)
jar cfm ./tmp/histoiremondiale.jar ./tmp/meta-inf/MANIFEST.MF -C ./tmp/bin/ .

REM création de l'exécutable .exe (utiliser launch4j et histoire.xml)
echo création de l'exécutable (histoiremondiale.exe)
"%ProgramFiles(x86)%\Launch4j\launch4jc.exe" launch4j\histoire.xml 1>nul
:encore
REM on ne passe à la création du setup que si l'exécutable est créé
if exist tmp\histoiremondiale.exe goto :setup
goto :encore

:setup
REM création du setup (utiliser Inno Setup et histoire.iss)
echo création du setup (histoiremondiale-2.1.setup.exe)
"%ProgramFiles(x86)%\Inno Setup 6\ISCC.exe" innosetup\histoire.iss 1>nul

:archive
xcopy %SOURCE%distribution\execution\*.bat tmp /Q /I /Y
xcopy %SOURCE%distribution\execution\*.sh tmp /Q /I /Y
cd tmp
"%ProgramFiles(x86)%\7-zip\7z.exe" a histoiremondiale-2.1.zip bib donnees icones licence "%%notes de version.txt" *.bat *.sh *.jar 1>nul
cd ..

echo FIN
:fin
pause
echo on