/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire.igraphique;

import static fr.histoiremondiale.histoire.HistoireMondiale.ADRESSE_CONTACT_HISTOIRE;
import static fr.histoiremondiale.histoire.HistoireMondiale.LIEN_PAGE_LICENCE_CODE_SOURCE;
import static fr.histoiremondiale.histoire.HistoireMondiale.LIEN_PAGE_LICENCE_DONNEES;
import static fr.histoiremondiale.histoire.HistoireMondiale.LIEN_PAGE_LICENCE_ICONES;
import static fr.histoiremondiale.histoire.HistoireMondiale.URL_PROJET;
import static fr.histoiremondiale.histoire.HistoireMondiale.URL_SITE_WEB;
import static fr.histoiremondiale.histoire.RessourcesAppli.ICONE_APPLI_32;
import static fr.histoiremondiale.histoire.RessourcesAppli.ICONE_LICENCE_CODE_SOURCE;
import static fr.histoiremondiale.histoire.RessourcesAppli.ICONE_LICENCE_DONNEES;
import static fr.histoiremondiale.histoire.RessourcesAppli.ICONE_LICENCE_ICONES;
import static fr.histoiremondiale.histoire.utiles.igraphique.swing.Textes.FONTE_GRASSE;
import static fr.histoiremondiale.histoire.utiles.igraphique.swing.Textes.FONTE_SIMPLE;
import static fr.histoiremondiale.histoire.utiles.igraphique.swing.Textes.lien;
import static fr.histoiremondiale.histoire.utiles.igraphique.swing.Textes.texte;

import java.awt.BorderLayout ;
import java.awt.Color ;
import java.awt.Component ;
import java.awt.Cursor ;
import java.awt.Dimension ;
import java.awt.FlowLayout ;
import java.awt.event.ActionEvent ;
import java.awt.event.ActionListener ;
import java.awt.event.MouseEvent ;
import java.awt.image.BufferedImage ;
import java.util.ArrayList ;
import java.util.List ;

import javax.swing.JButton ;
import javax.swing.JComponent ;
import javax.swing.JDialog ;
import javax.swing.JFrame ;
import javax.swing.JLabel ;
import javax.swing.JPanel ;

import fr.histoiremondiale.histoire.HistoireMondiale;
import fr.histoiremondiale.histoire.RessourcesAppli;
import fr.histoiremondiale.histoire.utiles.igraphique.swing.EcouteurDialInfos;
import fr.histoiremondiale.histoire.utiles.igraphique.swing.Fenetres;
import fr.histoiremondiale.histoire.utiles.igraphique.swing.JImage;
import fr.histoiremondiale.histoire.utiles.igraphique.swing.gestplacement.PlaceurListe;



/**
 * Boîte de dialogue "A propos".<br>
 */
public class DialAPropos extends JDialog implements ActionListener
{

    // Données de la boîte
    private JButton bt_ok ;
    
    
    
    /**
     * Constructeur.
     * @param parent Fenêtre mère.
     */
    public DialAPropos (JFrame parent)
    {
        super (parent, "A propos d'Histoire", true) ;
        
        
        // Charger l'image/icône de la boîte de dialogue
        BufferedImage icone = RessourcesAppli.imageIcone (ICONE_APPLI_32) ;
        this.setIconImage (icone) ;
        
        
        // Créer les composants
        // (partie haute)
        JPanel p_haut = new JPanel (new PlaceurListe (PlaceurListe.COLONNE, PlaceurListe.ALIGN_CENTRE)) ;
        p_haut.add (new JLabel (" ")) ;
        p_haut.add (new JImage (p_haut.getBackground(), icone, null)) ;
        p_haut.add (new JLabel (" ")) ;
        p_haut.add (texte (FONTE_GRASSE, "Histoire " + HistoireMondiale.NUMERO_VERSION)) ;
        // (partie du milieu)
        JPanel p_milieu = new JPanel (new PlaceurListe (PlaceurListe.COLONNE, PlaceurListe.ALIGN_CENTRE)) ;
        p_milieu.add (texte (FONTE_SIMPLE, "L'histoire du monde à travers les siècles")) ;
        p_milieu.add (lien  (FONTE_SIMPLE, "(" + URL_SITE_WEB + ")", URL_SITE_WEB)) ;
        // (partie basse)
        JPanel p_bas = new JPanel (new PlaceurListe (PlaceurListe.COLONNE)) ;
        p_bas.add (new JLabel (" ")) ;
        
        // (licence du code source)
        p_bas.add (texte (FONTE_GRASSE, "Programme : Patrice HENRIO, Sylvain LAVALLEY - Copyright " + HistoireMondiale.DATES_DROITS_COPIE_CODE_SOURCE)) ;
        p_bas.add (texte (FONTE_SIMPLE, "(patrice.henrio@laposte.net, sylvain.lavalley@laposte.net)")) ;
        JPanel p_licenceCodeSource = new JPanel (new PlaceurListe (PlaceurListe.COLONNE)) ;
        p_licenceCodeSource.add (texte (FONTE_SIMPLE, "Ce logiciel est modifiable et redistribuable sous les termes de la licence " + HistoireMondiale.LICENCE_CODE_SOURCE + ".")) ;
        List<JComponent> detailsLicenceCodeSource = new ArrayList<>() ;
        if ("AGPLv3".equals (HistoireMondiale.LICENCE_CODE_SOURCE))
        {
            detailsLicenceCodeSource.add (new JLabel (" ")) ;
            detailsLicenceCodeSource.add (texte (FONTE_SIMPLE, "En tant qu'utilisateur du logiciel, la licence AGPLv3 vous permet d'avoir accès à\n" +
                                                               "    son code source, pour voir comment il fonctionne ou le modifier vous-même.\n" +
                                                               "\n" +
                                                               "Si vous redistribuez le logiciel, vous devez le redistribuer sous la même licence.\n" +
                                                               "\n" +
                                                               "Si vous modifiez le logiciel, les utilisateurs doivent avoir accès au code source\n" +
                                                               "    modifié. Si vous utilisez une partie du logiciel dans un autre programme, ce\n" +
                                                               "    programme doit lui-même être sous licence AGPLv3.\n" +
                                                               "\n" +
                                                               "Les détails de la licence se trouvent dans un fichier avec le code source du logiciel.\n" +
                                                               "\n" +
                                                               "Vous pouvez également consulter le texte de la licence en différentes langues à cette adresse :")) ;
            detailsLicenceCodeSource.add (lien  (FONTE_SIMPLE, "    " + LIEN_PAGE_LICENCE_CODE_SOURCE, LIEN_PAGE_LICENCE_CODE_SOURCE)) ;
            detailsLicenceCodeSource.add (new JLabel (" ")) ;
        }
        else
        {
            System.err.println ("Erreur : pas de texte de licence correspondant au nom indiqué") ;
            detailsLicenceCodeSource.add (texte (FONTE_SIMPLE, "(oups... si on change la licence il faudrait mettre à jour les explications)")) ;
        }
        ajouterInfosLicence (p_bas, p_licenceCodeSource, ICONE_LICENCE_CODE_SOURCE, detailsLicenceCodeSource) ;
        p_bas.add (new JLabel (" ")) ;

        // (licence des données)
        p_bas.add (texte (FONTE_GRASSE, "Données : Patrice HENRIO - Copyright " + HistoireMondiale.DATES_DROITS_COPIE_DONNEES)) ;
        p_bas.add (texte (FONTE_SIMPLE, "(" + ADRESSE_CONTACT_HISTOIRE + ")")) ;
        JPanel p_licenceDonnees = new JPanel (new PlaceurListe (PlaceurListe.COLONNE)) ;
        p_licenceDonnees.add (texte (FONTE_SIMPLE, "Les données du logiciel sont modifiables et redistribuables sous les termes de la\n" +    
                                                   "licence " + HistoireMondiale.LICENCE_DONNEES + ".")) ;
        List<JComponent> detailsLicenceDonnees = new ArrayList<>() ;
        if ("Creative Commons Attribution Partage dans les mêmes conditions (CC-by-sa)".equals (HistoireMondiale.LICENCE_DONNEES))
        {
            detailsLicenceDonnees.add (new JLabel (" ")) ;
            detailsLicenceDonnees.add (texte (FONTE_SIMPLE, "Cette licence vous autorise à copier, modifier et redistribuer les données du logiciel\n" +
                                                            "à ces conditions :\n" +
                                                            "    - Le nom de l'auteur d'origine doit être indiqué.\n" +
                                                            "    - Si vous redistribuez les données, vous devez le faire sous la même licence et donc\n" +
                                                            "      dans les mêmes conditions que celles exposées ici.\n" +
                                                            "\n" +
                                                            "Les détails de la licence se trouvent dans un fichier avec le code source du logiciel.\n" +
                                                            "\n" +
                                                            "Vous pouvez également consulter le texte de la licence à cette adresse :")) ;
            detailsLicenceDonnees.add (lien  (FONTE_SIMPLE, "    " + LIEN_PAGE_LICENCE_DONNEES, LIEN_PAGE_LICENCE_DONNEES)) ;
            detailsLicenceDonnees.add (new JLabel (" ")) ;
        }
        else
        {
            System.err.println ("Erreur : pas de texte de licence correspondant au nom indiqué") ;
            detailsLicenceDonnees.add (texte (FONTE_SIMPLE, "(oups... si on change la licence il faudrait mettre à jour les explications)")) ;
        }
        ajouterInfosLicence (p_bas, p_licenceDonnees, ICONE_LICENCE_DONNEES, detailsLicenceDonnees) ;
        p_bas.add (new JLabel (" ")) ;
        
        // (licence des icônes)
        p_bas.add (texte (FONTE_GRASSE, "Icônes : Marjory (MPM) - Copyright " + HistoireMondiale.DATES_DROITS_COPIE_ICONES)) ;
//        p_bas.add (lien  (FONTE_SIMPLE, "(" + URL_SITE_GRAPHISTE + ")", URL_SITE_GRAPHISTE)) ;
        JPanel p_licenceIcones = new JPanel (new PlaceurListe (PlaceurListe.COLONNE)) ;
        p_licenceIcones.add (texte (FONTE_SIMPLE, "Les icônes du logiciel sont modifiables et redistribuables sous les termes de la\n" +    
                                                  HistoireMondiale.LICENCE_ICONES + ".")) ;

        List<JComponent> detailsLicenceIcones = new ArrayList<>() ;
        if ("Licence Art Libre".equals (HistoireMondiale.LICENCE_ICONES))
        {
                    detailsLicenceIcones.add (new JLabel (" ")) ;
                    detailsLicenceIcones.add (texte (FONTE_SIMPLE, "Cette licence vous autorise à copier, modifier et redistribuer les icônes du logiciel\n" +
                                                                   "à ces conditions :\n" +
                                                                   "    - Le nom de l'auteur d'origine doit être indiqué.\n" +
                                                                   "    - Si vous redistribuez les icônes, vous devez le faire sous la même licence et donc\n" +
                                                                   "      dans les mêmes conditions que celles exposées ici.\n" +
                                                                   "\n" +
                                                                   "Les détails de la licence se trouvent dans un fichier avec le code source du logiciel.\n" +
                                                                   "\n" +
                                                                   "Vous pouvez également consulter le texte de la licence à cette adresse :")) ;
                    detailsLicenceIcones.add (lien  (FONTE_SIMPLE, "    " + LIEN_PAGE_LICENCE_ICONES, LIEN_PAGE_LICENCE_ICONES)) ;
                    detailsLicenceIcones.add (new JLabel (" ")) ;
        }
        else
        {
            System.err.println ("Erreur : pas de texte de licence correspondant au nom indiqué") ;
            detailsLicenceIcones.add (texte (FONTE_SIMPLE, "(oups... si on change la licence il faudrait mettre à jour les explications)")) ;
        }
        ajouterInfosLicence (p_bas, p_licenceIcones, ICONE_LICENCE_ICONES, detailsLicenceIcones) ;
        p_bas.add (new JLabel (" ")) ;
        p_bas.add (texte (FONTE_SIMPLE, "Pour plus d'informations sur une licence, cliquez sur le texte ou l'icône.")) ;
        p_bas.add (new JLabel (" ")) ;
        JPanel p_hebergement = new JPanel (new PlaceurListe (PlaceurListe.LIGNE)) ;
        p_hebergement.add (texte (FONTE_SIMPLE, "Hébergement du projet : ")) ;
        p_hebergement.add (lien  (FONTE_SIMPLE, URL_PROJET, URL_PROJET)) ;
        p_bas.add (p_hebergement) ;
        p_bas.add (new JLabel (" ")) ;
        p_bas.add (texte (FONTE_SIMPLE, "Les avis et retours divers sont les bienvenus. N'hésitez pas à contacter les auteurs.")) ;
        p_bas.add (new JLabel (" ")) ;

        // (bouton Ok)
        JPanel p_bouton = new JPanel (new FlowLayout (FlowLayout.CENTER)) ;
        this.bt_ok = new JButton ("Ok") ;
        this.bt_ok.addActionListener (this) ;
        p_bouton.add (this.bt_ok) ;
        

        
        // Assembler les composants
        JPanel p_fond = new JPanel (new PlaceurListe (PlaceurListe.COLONNE, PlaceurListe.ALIGN_CENTRE + PlaceurListe.ALIGN_HAUT)) ;
        p_fond.add (p_haut) ;
        p_fond.add (p_milieu) ;
        p_fond.add (p_bas) ;
        p_fond.add (p_bouton) ;
        this.getContentPane().setLayout (new BorderLayout()) ;
        this.getContentPane().add (p_fond, BorderLayout.CENTER) ;


        // Touches permettant de fermer la fenêtre
        Fenetres.ajouterEcouteurEntreePourMasquer (this) ;
        Fenetres.ajouterEcouteurEchapPourMasquer  (this) ;
        
        // Paramétrer la boîte
        this.pack() ;
        this.setSize (this.getWidth() + 50, this.getHeight() + 12) ;
        // (centrer sur la fenêtre mère ; le cas null peut arriver dans les tests par exemple)
        Fenetres.centrer (this, parent) ;
    }
    
    
    // Ajouter un panneau d'informations sur la licence au panneau en paramètre
    private void ajouterInfosLicence (JPanel p_parent, JPanel p_infosLicence, String nomIconeLicence, List<JComponent> detailsLicence)
    {
        BufferedImage iconeLicence = RessourcesAppli.imageIconeLicence (nomIconeLicence) ;
    
        // Compléter le panneau d'infos sur la licence
        p_infosLicence.setVisible       (true) ;
        JPanel p_icone = new JPanel (new FlowLayout (FlowLayout.LEFT)) ;
        p_icone.add (new JImage (new Color (0, 0, 0, 0),
                                 iconeLicence,
                                 new Dimension (iconeLicence.getWidth(), iconeLicence.getHeight()))) ;
        p_infosLicence.add (p_icone) ;
        
        // Ajouter le panneau au parent
        JPanel p_interne = new JPanel (new FlowLayout (FlowLayout.LEFT)) ;
        p_interne.add (p_infosLicence) ;
        p_interne.setCursor (Cursor.getPredefinedCursor (Cursor.HAND_CURSOR)) ;
        
        // Ajouter l'écouteur pour la boîte de dialogue de détails
        EcouteurDialInfos ecouteur = new EcouteurDialInfos (this, detailsLicence) ;
        p_interne.addMouseListener (ecouteur) ;
        // (ajouter aux composants du panneau de licence, sinon ça ne fonctionne pas quand on clique dessus)
        for (Component c : p_infosLicence.getComponents())
            c.addMouseListener (ecouteur) ;

        p_parent.add (p_interne) ;
    }
    
    
    // Actions sur la boîte de dialogue
    public void actionPerformed (ActionEvent evt)
    {
        if (evt.getSource() == this.bt_ok)
            this.setVisible (false) ;
        else
            throw new IllegalStateException ("Source inconnue pour l'événement : " + evt) ;
    }

    
    
    // Méthodes non implémentées de MouseListener
    public void mouseEntered  (MouseEvent evt) {} ;
    public void mouseExited   (MouseEvent evt) {} ;
    public void mousePressed  (MouseEvent evt) {} ;
    public void mouseReleased (MouseEvent evt) {} ;
    

// Méthode de test
public static void main (String[] args) throws Exception
{
    DialAPropos dial = new DialAPropos(null) ;
    dial.setVisible (true) ;
}

}
