/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire.igraphique.actions;

import static javax.swing.JOptionPane.WARNING_MESSAGE ;
import static javax.swing.JOptionPane.YES_NO_OPTION ;
import static javax.swing.JOptionPane.YES_OPTION ;
import static javax.swing.JOptionPane.showConfirmDialog ;

import javax.swing.JOptionPane ;

import fr.histoiremondiale.histoire.HistoireMondiale;
import fr.histoiremondiale.histoire.stockage.AccesDonneesConfiguration;
import fr.histoiremondiale.histoire.stockage.AccesDonneesIGraphique;
import fr.histoiremondiale.histoire.utiles.exceptions.Exceptions;



/**
 * Actions générales sur l'application et ses données.
 */
public class ActionsGeneralesAppli
{

    /**
     * Sauvegarde l'état de l'application puis l'arrête.
     */
    public static void sauverEtatEtQuitter ()
    {
        sauverEtatAppli() ;
        quitter() ;
    }
    
    
    /**
     * Arrête l'application.
     */
    public static void quitter ()
    {
        System.exit (0) ;
    }
    
    
    /**
     * Réinitialise les emplacements des textes, ... qui peuvent être modifiées par l'utilisateur.
     */
    public static void revenirAuxValeursInitiales ()
    {
        // Demander confirmation avant d'effectuer l'action
        if (showConfirmDialog (HistoireMondiale.instance().fenPrincipale(),
                               "Vous allez réinitialiser l'emplacement des textes et les niveaux de loupe à partir desquels ils s'affichent.\n" +
                                 "Voulez-vous continuer ?",
                               "Confirmation",
                               YES_NO_OPTION,
                               WARNING_MESSAGE)
            == YES_OPTION)
        {
            HistoireMondiale.instance().donneesIGraphique().reinitialiserDonneesModifiees() ;
        }
    }
    
    
    /**
     * Sauvegarde l'état de l'application
     */
    public static void sauverEtatAppli ()
    {
        HistoireMondiale application = HistoireMondiale.instance() ;
        
        
        // Sauvegarder la configuration
        try
        {
            new AccesDonneesConfiguration().sauverConfig (application) ;
            new AccesDonneesIGraphique (application.config().chemRepDonnees(), application.config().chemRepIcones()).sauverInfosIGraphique (application.donneesIGraphique()) ;
        }
        catch (Throwable e)
        {
            e.printStackTrace() ;
            JOptionPane.showMessageDialog (null,
                                           "Erreur lors de la sauvegarde de l'état de l'application.\n" +
                                           "Les paramètres n'ont peut-être pas été sauvegardés.\n" +
                                           "Message d'erreur : " + Exceptions.extraireMessagesErreur (e),
                                           "Erreur de sauvegarde des paramètres",
                                           JOptionPane.ERROR_MESSAGE) ;
        }
        
    }
    
    
}
