/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire.utiles.exttypes;



/**
 * Fonctions de manipulation de nombres en "virgule fixe" (basés sur des flottants, mais on arrondit à n
 *   chiffres après la virgule pour les manipuler).<br>
 * Attention aux valeurs spéciales (NaN, POSITIVE/NEGATIVE_INFINITY !<br>
 * Il s'agit d'une classe spécialisée pour cette application.
 */
public class Fixes
{

    public static final int NB_DECIMALES   = 2 ;
    public static final int MULTIPLICATEUR = (int) Math.pow (10, NB_DECIMALES) ;

    
    
    /**
     * Renvoie -1 si val1 est inférieure à val2.
     * Renvoie +1 si val1 est supérieure à val2.
     * Renvoie 0 si les deux valeurs sont égales.
     * @param val1 La première valeur.
     * @param val2 La seconde  valeur.
     * @return -1, 0 ou +1 selon le résultat de la comparaison.
     */
    public static int comparaison (double val1, double val2)
    {
        // Ajuster les valeurs
        int val1Ajustee = (int) Math.round (val1 * MULTIPLICATEUR) ;
        int val2Ajustee = (int) Math.round (val2 * MULTIPLICATEUR) ;
        
        // Renvoyer le résultat de la comparaison
        return (int) Math.signum (val1Ajustee - val2Ajustee) ;
    }
    
    
    // Fonctions de comparaison renvoyant un booléen.
    public static boolean inferieur (double val1, double val2) { return comparaison (val1, val2) <  0 ; }
    public static boolean infEgal   (double val1, double val2) { return comparaison (val1, val2) <= 0 ; }
    public static boolean egal      (double val1, double val2) { return comparaison (val1, val2) == 0 ; }
    public static boolean supEgal   (double val1, double val2) { return comparaison (val1, val2) >= 0 ; }
    public static boolean superieur (double val1, double val2) { return comparaison (val1, val2) >  0 ; }
    
}
