/**
 * 
 * Copyright 2010-2020 Patrice Henrio, Sylvain Lavalley
 * 
 * Ce fichier fait partie du logiciel Histoire.
 *
 * Histoire est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier sous les termes de la licence Affero GPL publiée par
 * la Fondation pour le logiciel libre (Free Software Foundation), en
 * choisissant la version 3 de cette licence ou n'importe quelle version
 * ultérieure, à votre convenance.
 *
 * Histoire est distribué en espérant qu'il sera utile, mais SANS GARANTIE
 * D'AUCUNE SORTE : y compris d'être vendable ou de pouvoir servir un
 * but donné. Voir le texte de la licence AGPL pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la licence AGPL avec Histoire.
 * Si ce n'est pas le cas, regardez à cette adresse :
 * <http://www.gnu.org/licenses/>.
 *  
 */
package fr.histoiremondiale.histoire.utiles.igraphique.swing;

import java.awt.BorderLayout ;
import java.awt.Color ;
import java.awt.FlowLayout ;
import java.awt.event.ActionEvent ;
import java.awt.event.ActionListener ;
import java.awt.event.MouseEvent ;
import java.awt.event.MouseListener ;
import java.util.List ;

import javax.swing.JButton ;
import javax.swing.JComponent ;
import javax.swing.JDialog ;
import javax.swing.JPanel ;

import fr.histoiremondiale.histoire.utiles.igraphique.swing.gestplacement.PlaceurListe;



/**
 * Boîte de dialogue sans décorations destinée à l'affichage d'informations.
 */
public class DialInfos extends JDialog implements MouseListener
{
    
    private static final Color COUL_FOND = new Color (217, 229, 236) ;
    
    

    /**
     * Constructeur.
     * @param parent La boîte mère.
     * @param composants Les composants à placer dans la boîte.
     */
    public DialInfos (JDialog parent, List<JComponent> composants)
    {
        super (parent, true) ;
        
        // Ajouter les textes à la boîte de dialogue
        JPanel p_textes = new JPanel (new PlaceurListe (PlaceurListe.COLONNE)) ;
        p_textes.setBackground (COUL_FOND) ;
        for (JComponent texte : composants)
        {
            texte.setBackground (p_textes.getBackground()) ;
            p_textes.add (texte) ;
        }
        
        // Ajouter le bouton Ok
        JPanel p_bouton = new JPanel (new FlowLayout (FlowLayout.CENTER)) ;
        JButton bt_ok = new JButton ("Ok") ;
        bt_ok.addActionListener (new ActionListener()
        {
            public void actionPerformed (ActionEvent arg0)
            {
                masquer() ;
            }
        }) ;
        p_bouton.add (bt_ok) ;
        p_bouton.setBackground (COUL_FOND) ;
        
        // Assembler les composants
        JPanel p_fond = new JPanel (new PlaceurListe (PlaceurListe.COLONNE, PlaceurListe.ALIGN_CENTRE + PlaceurListe.ALIGN_HAUT)) ;
        p_fond.add (p_textes) ;
        p_fond.add (p_bouton) ;
        p_fond.setBackground (COUL_FOND) ;
        this.getContentPane().setLayout (new BorderLayout()) ;
        this.getContentPane().add (p_fond, BorderLayout.CENTER) ;
        
// Non : ça empêche de copier du texte dans la boîte de dialogue
//        // Clic sur la boîte de dialogue pour la masquer.
//        this.addMouseListener     (this) ;
//        p_fond.addMouseListener   (this) ;
//        p_textes.addMouseListener (this) ;
//        for (Component c : p_textes.getComponents())
//        {
//            // (on ne pourrit pas les composants qui réagissent déjà à la souris)
//            if (c.getMouseListeners().length == 0)
//                c.addMouseListener (this) ;
//            else
//                System.out.println ("Ecouteurs de souris : " + c.getMouseListeners()) ;
//        }
        
        
        // Touches permettant de fermer la boîte de dialogue
        // (attention, ça ne passe pas par masquer() ;
        Fenetres.ajouterEcouteurEntreePourMasquer (this) ;
        Fenetres.ajouterEcouteurEchapPourMasquer  (this) ;

        // Paramétrer la boîte de dialogue
        this.setUndecorated (true) ;
        this.pack() ;
        this.setSize (this.getWidth() + 10, this.getHeight() + 5) ;
    }
    
    
    /**
     * Affiche la boîte de dialogue, centrée sur la position indiquée.
     * @param x Abscisse de la position.
     * @param y Ordonnée de la position.
     */
    public void afficher (int x, int y)
    {
        Fenetres.centrer (this, x, y) ;
        this.setVisible  (true) ;
    }
    
    
    /**
     * Masque la boîte de dialogue.
     */
    public void masquer ()
    {
        // Note : attention si on change cette méthode, certains moyens de fermer la boîte ne passent pas
        //        par ici (touches de raccourci Entrée/Echap par exemple)
        this.setVisible (false) ;
    }

    
    
    // Traitement des clics de souris
    public void mousePressed  (MouseEvent evt)
    {
        masquer() ;
    }

    
    // Méthodes non implémentées
    public void mouseClicked  (MouseEvent evt) {} ;
    public void mouseEntered  (MouseEvent evt) {} ;
    public void mouseExited   (MouseEvent evt) {} ;
    public void mouseReleased (MouseEvent evt) {} ;
        
}
