/*
 * Decompiled with CFR 0.152.
 */
package fr.histoiremondiale.histoire.utiles.math;

import fr.histoiremondiale.histoire.utiles.math.PointPlan;
import java.util.ArrayList;
import java.util.List;

public class CalculsPlan {
    public static PointPlan creerPointCoordAngulaires(double d, double d2) {
        double d3 = Math.floor(d * Math.cos(d2));
        double d4 = Math.floor(d * Math.sin(d2));
        return new PointPlan(d3, d4);
    }

    public static double angleOrigine(PointPlan pointPlan) {
        PointPlan pointPlan2 = new PointPlan(0.0, 0.0);
        PointPlan pointPlan3 = new PointPlan(100.0, 0.0);
        return CalculsPlan.angle(pointPlan2, pointPlan3, pointPlan);
    }

    public static double angle(PointPlan pointPlan, PointPlan pointPlan2, PointPlan pointPlan3) {
        double d = CalculsPlan.angleRelatif(pointPlan, pointPlan2, pointPlan3);
        return d >= 0.0 ? d : Math.PI * 2 + d;
    }

    public static double angleRelatif(PointPlan pointPlan, PointPlan pointPlan2, PointPlan pointPlan3) {
        int n = CalculsPlan.positionRelative(pointPlan, pointPlan2, pointPlan3);
        if (n == 0) {
            if (pointPlan2.x() == pointPlan.x()) {
                return (pointPlan3.y() - pointPlan.y()) * (pointPlan2.y() - pointPlan.y()) < 0.0 ? Math.PI : 0.0;
            }
            return (pointPlan3.x() - pointPlan.x()) * (pointPlan2.x() - pointPlan.x()) < 0.0 ? Math.PI : 0.0;
        }
        double d = Math.acos(CalculsPlan.produitScalaire(pointPlan, pointPlan2, pointPlan3) / (pointPlan.distanceA(pointPlan2) * pointPlan.distanceA(pointPlan3)));
        if (n < 0) {
            d = -d;
        }
        return d;
    }

    public static int positionRelative(PointPlan pointPlan, PointPlan pointPlan2, PointPlan pointPlan3) {
        double d = (pointPlan2.x() - pointPlan.x()) * (pointPlan3.y() - pointPlan.y()) - (pointPlan2.y() - pointPlan.y()) * (pointPlan3.x() - pointPlan.x());
        if (Math.abs(d) < 1.0E-10) {
            d = 0.0;
        }
        return (int)Math.signum(d);
    }

    public static double produitScalaire(PointPlan pointPlan, PointPlan pointPlan2, PointPlan pointPlan3) {
        return (pointPlan2.x() - pointPlan.x()) * (pointPlan3.x() - pointPlan.x()) + (pointPlan2.y() - pointPlan.y()) * (pointPlan3.y() - pointPlan.y());
    }

    public static double rayonCercleCirconscrit(int n, int n2) {
        return Math.sqrt((n * n + n2 * n2) / 4);
    }

    public static double sommeAngles(PointPlan pointPlan, List<PointPlan> list) {
        double d = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            d += CalculsPlan.angleRelatif(pointPlan, list.get(i), list.get((i + 1) % list.size()));
        }
        return d;
    }

    public static PointPlan intersectionSegmentCercle(PointPlan pointPlan, PointPlan pointPlan2, double d) {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6 = pointPlan.x();
        double d7 = pointPlan.y();
        double d8 = pointPlan2.x();
        double d9 = 2.0 * (d8 * (d6 - d8) + (d5 = pointPlan2.y()) * (d7 - d5));
        double d10 = (-d9 + Math.sqrt(d4 = d9 * d9 - 4.0 * (d3 = (d6 - d8) * (d6 - d8) + (d7 - d5) * (d7 - d5)) * (d2 = d8 * d8 + d5 * d5 - d * d))) / (2.0 * d3);
        if (d10 < 0.0 || d10 > 1.0) {
            d10 = (-d9 - Math.sqrt(d4)) / (2.0 * d3);
        }
        if (d10 < 0.0 || d10 > 1.0) {
            System.out.println("ce cas ne devrait jamais se produire");
            System.out.println("determinerPointSurLeCercle de rayon : alerte " + d);
            System.out.println("t = " + d10);
            System.out.println("A = " + pointPlan.toString());
            System.out.println("B = " + pointPlan2.toString());
            return d10 < 0.0 ? new PointPlan(Double.NaN, 0.0) : new PointPlan(0.0, Double.NaN);
        }
        double d11 = d10 * d6 + (1.0 - d10) * d8;
        double d12 = d10 * d7 + (1.0 - d10) * d5;
        return new PointPlan(d11, d12);
    }

    public static PointPlan changementOrigineCentreVersCoinHautGauche(PointPlan pointPlan, int n, int n2) {
        return new PointPlan((double)(n / 2) + pointPlan.x(), (double)(n2 / 2) - pointPlan.y());
    }

    public static List<PointPlan> changementOrigineCentreVersCoinHautGauche(List<PointPlan> list, int n, int n2) {
        ArrayList<PointPlan> arrayList = new ArrayList<PointPlan>();
        for (PointPlan pointPlan : list) {
            arrayList.add(CalculsPlan.changementOrigineCentreVersCoinHautGauche(pointPlan, n, n2));
        }
        return arrayList;
    }

    public static List<List<PointPlan>> changementOrigineCentreVersCoinHautGauchePourTout(List<List<PointPlan>> list, int n, int n2) {
        ArrayList<List<PointPlan>> arrayList = new ArrayList<List<PointPlan>>();
        for (List<PointPlan> list2 : list) {
            List<PointPlan> list3 = CalculsPlan.changementOrigineCentreVersCoinHautGauche(list2, n, n2);
            arrayList.add(list3);
        }
        return arrayList;
    }
}

